/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.spec;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.ByteBuffer;

public interface Script {
    default public byte[] serialize() throws CborSerializationException {
        byte[] first = this.getScriptTypeBytes();
        byte[] serializedBytes = this.serializeScriptBody();
        byte[] finalBytes = ByteBuffer.allocate(first.length + serializedBytes.length).put(first).put(serializedBytes).array();
        return finalBytes;
    }

    default public byte[] scriptRefBytes() throws CborSerializationException {
        int type = this.getScriptType();
        byte[] serializedBytes = this.serializeScriptBody();
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger((long)type));
        array.add((DataItem)new ByteString(serializedBytes));
        try {
            return CborSerializationUtil.serialize((DataItem)array);
        }
        catch (CborException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
    }

    @JsonIgnore
    default public byte[] getScriptHash() throws CborSerializationException {
        return Blake2bUtil.blake2bHash224((byte[])this.serialize());
    }

    @JsonIgnore
    default public String getPolicyId() throws CborSerializationException {
        return HexUtil.encodeHexString((byte[])this.getScriptHash());
    }

    public DataItem serializeAsDataItem() throws CborSerializationException;

    public byte[] serializeScriptBody() throws CborSerializationException;

    @JsonIgnore
    public byte[] getScriptTypeBytes();

    @JsonIgnore
    public int getScriptType();
}

