/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.spec;

import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.ByteBuffer;

public interface Script {
    default public byte[] serialize() throws CborSerializationException {
        byte[] first = this.getScriptTypeBytes();
        byte[] serializedBytes = this.serializeScriptBody();
        byte[] finalBytes = ByteBuffer.allocate(first.length + serializedBytes.length).put(first).put(serializedBytes).array();
        return finalBytes;
    }

    @JsonIgnore
    default public byte[] getScriptHash() throws CborSerializationException {
        return Blake2bUtil.blake2bHash224((byte[])this.serialize());
    }

    @JsonIgnore
    default public String getPolicyId() throws CborSerializationException {
        return HexUtil.encodeHexString((byte[])this.getScriptHash());
    }

    public byte[] scriptRefBytes() throws CborSerializationException;

    public DataItem serializeAsDataItem() throws CborSerializationException;

    public byte[] serializeScriptBody() throws CborSerializationException;

    @JsonIgnore
    public byte[] getScriptTypeBytes();

    @JsonIgnore
    public int getScriptType();
}

