/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.common.cbor.custom;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.encoder.MapEncoder;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.common.cbor.custom.CustomCborEncoder;
import com.bloxbean.cardano.client.common.cbor.custom.SortedMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class CustomMapEncoder
extends MapEncoder {
    public CustomMapEncoder(CborEncoder encoder, OutputStream outputStream) {
        super(encoder, outputStream);
    }

    public void encode(Map map) throws CborException {
        Collection keys = map.getKeys();
        if (map.isChunked()) {
            this.encodeTypeChunked(MajorType.MAP);
        } else {
            this.encodeTypeAndLength(MajorType.MAP, keys.size());
        }
        if (keys.isEmpty()) {
            return;
        }
        if (map.isChunked()) {
            this.encodeNonCanonical(map);
            this.encoder.encode((DataItem)SimpleValue.BREAK);
        } else if (this.encoder.isCanonical() && !(map instanceof SortedMap)) {
            this.encodeCanonical(map);
        } else {
            this.encodeNonCanonical(map);
        }
    }

    private void encodeNonCanonical(Map map) throws CborException {
        for (DataItem key : map.getKeys()) {
            this.encoder.encode(key);
            this.encoder.encode(map.get(key));
        }
    }

    private void encodeCanonical(Map map) throws CborException {
        TreeMap<byte[], byte[]> sortedMap = new TreeMap<byte[], byte[]>(new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (o1.length < o2.length) {
                    return -1;
                }
                if (o1.length > o2.length) {
                    return 1;
                }
                for (int i = 0; i < o1.length; ++i) {
                    if (o1[i] < o2[i]) {
                        return -1;
                    }
                    if (o1[i] <= o2[i]) continue;
                    return 1;
                }
                return 0;
            }
        });
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CustomCborEncoder e = new CustomCborEncoder(byteArrayOutputStream);
        for (DataItem dataItem : map.getKeys()) {
            e.encode(dataItem);
            byte[] keyBytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            e.encode(map.get(dataItem));
            byte[] valueBytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            sortedMap.put(keyBytes, valueBytes);
        }
        for (Map.Entry entry : sortedMap.entrySet()) {
            this.write((byte[])entry.getKey());
            this.write((byte[])entry.getValue());
        }
    }
}

