/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.common.cbor.custom;

import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.Tag;
import com.bloxbean.cardano.client.common.cbor.custom.CustomByteStringEncoder;
import com.bloxbean.cardano.client.common.cbor.custom.CustomMapEncoder;
import java.io.OutputStream;

public class CustomCborEncoder
extends CborEncoder {
    private CustomMapEncoder customMapEncoder;
    private CustomByteStringEncoder chunkByteStringEncoder;

    public CustomCborEncoder(OutputStream outputStream) {
        super(outputStream);
        this.customMapEncoder = new CustomMapEncoder(this, outputStream);
        this.chunkByteStringEncoder = new CustomByteStringEncoder(this, outputStream);
    }

    public void encode(DataItem dataItem) throws CborException {
        if (dataItem == null) {
            dataItem = SimpleValue.NULL;
        }
        if (dataItem.getMajorType().equals((Object)MajorType.MAP)) {
            if (dataItem.hasTag()) {
                Tag tagDi = dataItem.getTag();
                this.encode((DataItem)tagDi);
            }
            this.customMapEncoder.encode((Map)dataItem);
        } else if (dataItem.getMajorType().equals((Object)MajorType.BYTE_STRING)) {
            if (dataItem.hasTag()) {
                Tag tagDi = dataItem.getTag();
                this.encode((DataItem)tagDi);
            }
            this.chunkByteStringEncoder.encode((ByteString)dataItem);
        } else {
            super.encode(dataItem);
        }
    }
}

