/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.util;

import com.bloxbean.cardano.client.util.CheckedFunction;
import java.util.function.Supplier;

public class Try<T> {
    private final T result;
    private final Exception exception;

    private Try(T result, Exception exception) {
        this.result = result;
        this.exception = exception;
    }

    public static <T> Try<T> of(CheckedFunction<T> supplier) {
        try {
            return new Try<T>(supplier.apply(), null);
        }
        catch (Exception e) {
            return new Try<Object>(null, e);
        }
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public T get() {
        if (this.exception != null) {
            throw new RuntimeException(this.exception);
        }
        return this.result;
    }

    public T getOrElse(T defaultValue) {
        if (this.exception != null) {
            return defaultValue;
        }
        return this.result;
    }

    public T orElseThrow(Supplier<? extends RuntimeException> exceptionSupplier) {
        if (this.exception != null) {
            throw exceptionSupplier.get();
        }
        return this.result;
    }

    public Exception getException() {
        return this.exception;
    }
}

