/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.crypto.api.impl;

import com.bloxbean.cardano.client.crypto.CryptoException;
import com.bloxbean.cardano.client.crypto.api.SigningProvider;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EdDSASigningProvider
implements SigningProvider {
    private static final EdDSAParameterSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");

    @Override
    public byte[] sign(byte[] message, byte[] privateKey) {
        try {
            EdDSAEngine signature = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
            signature.initSign((PrivateKey)new EdDSAPrivateKey(new EdDSAPrivateKeySpec(privateKey, spec)));
            signature.setParameter(EdDSAEngine.ONE_SHOT_MODE);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            throw new CryptoException("Signing error", e);
        }
    }

    @Override
    public byte[] signExtended(byte[] message, byte[] privateKey, byte[] publicKey) {
        return this.signExtended(message, privateKey);
    }

    @Override
    public byte[] signExtended(byte[] message, byte[] privateKey) {
        try {
            EdDSAEngine signature = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
            signature.initSign((PrivateKey)new EdDSAPrivateKey(new EdDSAPrivateKeySpec(spec, privateKey)));
            signature.setParameter(EdDSAEngine.ONE_SHOT_MODE);
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            throw new CryptoException("Extended signing error", e);
        }
    }

    @Override
    public boolean verify(byte[] signature, byte[] message, byte[] publicKey) {
        try {
            EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
            EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(publicKey, spec);
            EdDSAPublicKey vKey = new EdDSAPublicKey(pubKey);
            sgr.initVerify((PublicKey)vKey);
            sgr.setParameter(EdDSAEngine.ONE_SHOT_MODE);
            sgr.update(message);
            return sgr.verify(signature);
        }
        catch (Exception e) {
            throw new CryptoException("Signature verification error", e);
        }
    }
}

