/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.crypto;

import com.bloxbean.cardano.client.util.Tuple;
import java.util.ArrayList;
import org.bouncycastle.util.Arrays;

public class Bech32 {
    private static final int TotalMaxLength = 108;
    private static final int CheckSumSize = 6;
    private static final int HrpMinLength = 1;
    private static final int HrpMaxLength = 83;
    private static final int HrpMinValue = 33;
    private static final int HrpMaxValue = 126;
    private static final char Separator = '1';
    private static final String B32Chars = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";

    public static boolean isValid(String bech32EncodedString) {
        if (!Bech32.hasValidChars(bech32EncodedString)) {
            return false;
        }
        Tuple<String, byte[]> data = Bech32.bech32Decode(bech32EncodedString);
        if (((byte[])data._2).length < 6) {
            return false;
        }
        return Bech32.verifyChecksum((String)data._1, (byte[])data._2);
    }

    public static boolean hasValidChars(String bech32EncodedString) {
        if (bech32EncodedString == null || bech32EncodedString.isEmpty() || bech32EncodedString.length() > 108) {
            return false;
        }
        if (!bech32EncodedString.toLowerCase().equals(bech32EncodedString) && !bech32EncodedString.toUpperCase().equals(bech32EncodedString)) {
            return false;
        }
        int sepIndex = bech32EncodedString.lastIndexOf(49);
        if (sepIndex == -1) {
            return false;
        }
        String hrp = bech32EncodedString.substring(0, sepIndex);
        if (!Bech32.isValidHrp(hrp)) {
            return false;
        }
        String data = bech32EncodedString.substring(sepIndex + 1);
        return data.length() >= 6 && !data.chars().anyMatch(x -> B32Chars.indexOf(x) == -1);
    }

    private static boolean isValidHrp(String hrp) {
        return hrp != null && hrp.trim().length() > 0 && hrp.length() >= 1 && hrp.length() < 83 && hrp.chars().allMatch(character -> character >= 33 && character <= 126);
    }

    private static int polymod(byte[] values) {
        int c = 1;
        for (byte v_i : values) {
            int c0 = c >>> 25 & 0xFF;
            c = (c & 0x1FFFFFF) << 5 ^ v_i & 0xFF;
            if ((c0 & 1) != 0) {
                c ^= 0x3B6A57B2;
            }
            if ((c0 & 2) != 0) {
                c ^= 0x26508E6D;
            }
            if ((c0 & 4) != 0) {
                c ^= 0x1EA119FA;
            }
            if ((c0 & 8) != 0) {
                c ^= 0x3D4233DD;
            }
            if ((c0 & 0x10) == 0) continue;
            c ^= 0x2A1462B3;
        }
        return c;
    }

    private static byte[] expandHrp(String hrp) {
        byte[] result = new byte[2 * hrp.length() + 1];
        for (int i = 0; i < hrp.length(); ++i) {
            result[i] = (byte)(hrp.charAt(i) >> 5);
            result[i + hrp.length() + 1] = (byte)(hrp.charAt(i) & 0x1F);
        }
        return result;
    }

    private static boolean verifyChecksum(String hrp, byte[] data) {
        byte[] temp = Arrays.concatenate((byte[])Bech32.expandHrp(hrp), (byte[])data);
        return Bech32.polymod(temp) == 1;
    }

    private static Tuple<String, byte[]> bech32Decode(String bech32EncodedString) {
        bech32EncodedString = bech32EncodedString.toLowerCase();
        int separatorIndex = bech32EncodedString.lastIndexOf(49);
        String hrp = bech32EncodedString.substring(0, separatorIndex);
        String data = bech32EncodedString.substring(separatorIndex + 1);
        byte[] b32Arr = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            b32Arr[i] = (byte)B32Chars.indexOf(data.charAt(i));
        }
        return new Tuple((Object)hrp, (Object)b32Arr);
    }

    private static byte[] convertBits(byte[] data, int fromBits, int toBits, boolean pad) {
        int acc = 0;
        int bits = 0;
        int maxv = (1 << toBits) - 1;
        int maxacc = (1 << fromBits + toBits - 1) - 1;
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (byte _b : data) {
            int b = Byte.toUnsignedInt(_b);
            if (b >> fromBits > 0) {
                System.out.println("a");
                return null;
            }
            acc = (acc << fromBits | b) & maxacc;
            bits += fromBits;
            while (bits >= toBits) {
                result.add((byte)(acc >> (bits -= toBits) & maxv));
            }
        }
        if (pad) {
            if (bits > 0) {
                result.add((byte)(acc << toBits - bits & maxv));
            }
        } else if (bits >= fromBits || (byte)(acc << toBits - bits & maxv) != 0) {
            System.out.println("b");
            return null;
        }
        byte[] res = new byte[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            res[i] = (Byte)result.get(i);
        }
        return res;
    }

    public static Bech32Data decode(String bech32EncodedString) {
        Tuple<String, byte[]> bech32Data = Bech32.bech32Decode(bech32EncodedString);
        String hrp = (String)bech32Data._1;
        byte[] b32Arr = (byte[])bech32Data._2;
        if (b32Arr.length < 6) {
            throw new RuntimeException("Invalid data length.");
        }
        if (!Bech32.verifyChecksum(hrp, b32Arr)) {
            throw new RuntimeException("Invalid checksum.");
        }
        byte[] data = Arrays.copyOfRange((byte[])b32Arr, (int)0, (int)(b32Arr.length - 6));
        byte[] b256Arr = Bech32.convertBits(data, 5, 8, false);
        if (b256Arr == null) {
            throw new RuntimeException("Invalid data format.");
        }
        byte witVer = b32Arr[0];
        return new Bech32Data(hrp, b256Arr, witVer);
    }

    public static String encode(byte[] data, String hrp) {
        if (data == null || data.length == 0) {
            throw new RuntimeException("Data can not be null or empty.");
        }
        if (!Bech32.isValidHrp(hrp)) {
            throw new RuntimeException("Invalid HRP.");
        }
        byte[] b32Arr = Bech32.convertBits(data, 8, 5, true);
        byte[] checksum = Bech32.calculateCheckSum(hrp, b32Arr);
        b32Arr = Arrays.concatenate((byte[])b32Arr, (byte[])checksum);
        StringBuilder result = new StringBuilder(b32Arr.length + 1 + hrp.length());
        result.append(hrp).append('1');
        for (byte b : b32Arr) {
            result.append(B32Chars.charAt(b));
        }
        return result.toString();
    }

    private static byte[] calculateCheckSum(String hrp, byte[] data) {
        byte[] bytes = Arrays.concatenate((byte[])Arrays.concatenate((byte[])Bech32.expandHrp(hrp), (byte[])data), (byte[])new byte[6]);
        int pm = Bech32.polymod(bytes) ^ 1;
        byte[] result = new byte[6];
        for (int i = 0; i < 6; ++i) {
            result[i] = (byte)(pm >> 5 * (5 - i) & 0x1F);
        }
        return result;
    }

    public static class Bech32Data {
        public final String hrp;
        public final byte[] data;
        public final byte ver;

        private Bech32Data(String hrp, byte[] data, byte ver) {
            this.hrp = hrp;
            this.data = data;
            this.ver = ver;
        }
    }
}

