/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.crypto.cip1852;

import com.bloxbean.cardano.client.crypto.cip1852.Segment;

public class DerivationPath {
    private Segment purpose;
    private Segment coinType;
    private Segment account;
    private Segment role;
    private Segment index;

    public static DerivationPath createExternalAddressDerivationPath() {
        return DerivationPath.createExternalAddressDerivationPath(0);
    }

    public static DerivationPath createExternalAddressDerivationPath(int index) {
        return DerivationPath.builder().purpose(new Segment(1852, true)).coinType(new Segment(1815, true)).account(new Segment(0, true)).role(new Segment(0, false)).index(new Segment(index, false)).build();
    }

    public static DerivationPath createExternalAddressDerivationPathForAccount(int account) {
        return DerivationPath.builder().purpose(new Segment(1852, true)).coinType(new Segment(1815, true)).account(new Segment(account, true)).role(new Segment(0, false)).index(new Segment(0, false)).build();
    }

    public static DerivationPath createInternalAddressDerivationPath(int index) {
        return DerivationPath.builder().purpose(new Segment(1852, true)).coinType(new Segment(1815, true)).account(new Segment(0, true)).role(new Segment(1, false)).index(new Segment(index, false)).build();
    }

    public static DerivationPath createInternalAddressDerivationPathForAccount(int account) {
        return DerivationPath.builder().purpose(new Segment(1852, true)).coinType(new Segment(1815, true)).account(new Segment(account, true)).role(new Segment(1, false)).index(new Segment(0, false)).build();
    }

    public static DerivationPath createStakeAddressDerivationPath() {
        return DerivationPath.builder().purpose(new Segment(1852, true)).coinType(new Segment(1815, true)).account(new Segment(0, true)).role(new Segment(2, false)).index(new Segment(0, false)).build();
    }

    public static DerivationPath createStakeAddressDerivationPathForAccount(int account) {
        return DerivationPath.builder().purpose(new Segment(1852, true)).coinType(new Segment(1815, true)).account(new Segment(account, true)).role(new Segment(2, false)).index(new Segment(0, false)).build();
    }

    public static DerivationPath createDRepKeyDerivationPathForAccount(int account) {
        return DerivationPath.builder().purpose(new Segment(1852, true)).coinType(new Segment(1815, true)).account(new Segment(account, true)).role(new Segment(3, false)).index(new Segment(0, false)).build();
    }

    public static DerivationPathBuilder builder() {
        return new DerivationPathBuilder();
    }

    public Segment getPurpose() {
        return this.purpose;
    }

    public Segment getCoinType() {
        return this.coinType;
    }

    public Segment getAccount() {
        return this.account;
    }

    public Segment getRole() {
        return this.role;
    }

    public Segment getIndex() {
        return this.index;
    }

    public void setPurpose(Segment purpose) {
        this.purpose = purpose;
    }

    public void setCoinType(Segment coinType) {
        this.coinType = coinType;
    }

    public void setAccount(Segment account) {
        this.account = account;
    }

    public void setRole(Segment role) {
        this.role = role;
    }

    public void setIndex(Segment index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DerivationPath)) {
            return false;
        }
        DerivationPath other = (DerivationPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Segment this$purpose = this.getPurpose();
        Segment other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !((Object)this$purpose).equals(other$purpose)) {
            return false;
        }
        Segment this$coinType = this.getCoinType();
        Segment other$coinType = other.getCoinType();
        if (this$coinType == null ? other$coinType != null : !((Object)this$coinType).equals(other$coinType)) {
            return false;
        }
        Segment this$account = this.getAccount();
        Segment other$account = other.getAccount();
        if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
            return false;
        }
        Segment this$role = this.getRole();
        Segment other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)this$role).equals(other$role)) {
            return false;
        }
        Segment this$index = this.getIndex();
        Segment other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !((Object)this$index).equals(other$index));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DerivationPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Segment $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : ((Object)$purpose).hashCode());
        Segment $coinType = this.getCoinType();
        result = result * 59 + ($coinType == null ? 43 : ((Object)$coinType).hashCode());
        Segment $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
        Segment $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)$role).hashCode());
        Segment $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        return result;
    }

    public String toString() {
        return "DerivationPath(purpose=" + this.getPurpose() + ", coinType=" + this.getCoinType() + ", account=" + this.getAccount() + ", role=" + this.getRole() + ", index=" + this.getIndex() + ")";
    }

    public DerivationPath() {
    }

    public DerivationPath(Segment purpose, Segment coinType, Segment account, Segment role, Segment index) {
        this.purpose = purpose;
        this.coinType = coinType;
        this.account = account;
        this.role = role;
        this.index = index;
    }

    public static class DerivationPathBuilder {
        private Segment purpose;
        private Segment coinType;
        private Segment account;
        private Segment role;
        private Segment index;

        DerivationPathBuilder() {
        }

        public DerivationPathBuilder purpose(Segment purpose) {
            this.purpose = purpose;
            return this;
        }

        public DerivationPathBuilder coinType(Segment coinType) {
            this.coinType = coinType;
            return this;
        }

        public DerivationPathBuilder account(Segment account) {
            this.account = account;
            return this;
        }

        public DerivationPathBuilder role(Segment role) {
            this.role = role;
            return this;
        }

        public DerivationPathBuilder index(Segment index) {
            this.index = index;
            return this;
        }

        public DerivationPath build() {
            return new DerivationPath(this.purpose, this.coinType, this.account, this.role, this.index);
        }

        public String toString() {
            return "DerivationPath.DerivationPathBuilder(purpose=" + this.purpose + ", coinType=" + this.coinType + ", account=" + this.account + ", role=" + this.role + ", index=" + this.index + ")";
        }
    }
}

