/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import co.nstant.in.cbor.CborException;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.impl.DefaultUtxoSelector;
import com.bloxbean.cardano.client.config.Configuration;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

public class ScriptUtxoFinders {
    public static Optional<Utxo> findFirstByDatumHashUsingDatum(@NonNull UtxoSupplier utxoSupplier, @NonNull String scriptAddress, @NonNull Object datum) throws ApiException {
        if (scriptAddress == null) {
            throw new NullPointerException("scriptAddress is marked non-null but is null");
        }
        Objects.requireNonNull(datum);
        Objects.requireNonNull(utxoSupplier);
        String datumHash = ScriptUtxoFinders.getDatumHash(datum);
        return ScriptUtxoFinders.findFirstByDatumHash(utxoSupplier, scriptAddress, datumHash);
    }

    public static Optional<Utxo> findFirstByDatumHash(@NonNull UtxoSupplier utxoSupplier, @NonNull String scriptAddress, @NonNull String datumHash) throws ApiException {
        if (utxoSupplier == null) {
            throw new NullPointerException("utxoSupplier is marked non-null but is null");
        }
        if (scriptAddress == null) {
            throw new NullPointerException("scriptAddress is marked non-null but is null");
        }
        if (datumHash == null) {
            throw new NullPointerException("datumHash is marked non-null but is null");
        }
        DefaultUtxoSelector utxoSelector = new DefaultUtxoSelector(utxoSupplier);
        return utxoSelector.findFirst(scriptAddress, utx -> datumHash.equals(utx.getDataHash()));
    }

    public static List<Utxo> findAllByDatumHashUsingDatum(@NonNull UtxoSupplier utxoSupplier, @NonNull String scriptAddress, @NonNull Object datum) throws ApiException {
        if (scriptAddress == null) {
            throw new NullPointerException("scriptAddress is marked non-null but is null");
        }
        Objects.requireNonNull(datum);
        Objects.requireNonNull(utxoSupplier);
        String datumHash = ScriptUtxoFinders.getDatumHash(datum);
        return ScriptUtxoFinders.findAllByDatumHash(utxoSupplier, scriptAddress, datumHash);
    }

    public static List<Utxo> findAllByDatumHash(@NonNull UtxoSupplier utxoSupplier, @NonNull String scriptAddress, @NonNull String datumHash) throws ApiException {
        if (utxoSupplier == null) {
            throw new NullPointerException("utxoSupplier is marked non-null but is null");
        }
        if (scriptAddress == null) {
            throw new NullPointerException("scriptAddress is marked non-null but is null");
        }
        if (datumHash == null) {
            throw new NullPointerException("datumHash is marked non-null but is null");
        }
        DefaultUtxoSelector utxoSelector = new DefaultUtxoSelector(utxoSupplier);
        List utxos = utxoSelector.findAll(scriptAddress, utx -> datumHash.equals(utx.getDataHash()));
        return utxos;
    }

    public static Optional<Utxo> findFirstByInlineDatum(@NonNull UtxoSupplier utxoSupplier, @NonNull String scriptAddress, @NonNull Object inlineDatum) throws ApiException {
        if (utxoSupplier == null) {
            throw new NullPointerException("utxoSupplier is marked non-null but is null");
        }
        if (scriptAddress == null) {
            throw new NullPointerException("scriptAddress is marked non-null but is null");
        }
        if (inlineDatum == null) {
            throw new NullPointerException("inlineDatum is marked non-null but is null");
        }
        DefaultUtxoSelector utxoSelector = new DefaultUtxoSelector(utxoSupplier);
        String datumCborHex = ScriptUtxoFinders.serializeDatumToHex(inlineDatum);
        return utxoSelector.findFirst(scriptAddress, utx -> datumCborHex.equals(utx.getInlineDatum()));
    }

    public static List<Utxo> findAllByInlineDatum(@NonNull UtxoSupplier utxoSupplier, @NonNull String scriptAddress, @NonNull Object inlineDatum) throws ApiException {
        if (utxoSupplier == null) {
            throw new NullPointerException("utxoSupplier is marked non-null but is null");
        }
        if (scriptAddress == null) {
            throw new NullPointerException("scriptAddress is marked non-null but is null");
        }
        if (inlineDatum == null) {
            throw new NullPointerException("inlineDatum is marked non-null but is null");
        }
        DefaultUtxoSelector utxoSelector = new DefaultUtxoSelector(utxoSupplier);
        String datumCborHex = ScriptUtxoFinders.serializeDatumToHex(inlineDatum);
        List utxos = utxoSelector.findAll(scriptAddress, utx -> datumCborHex.equals(utx.getInlineDatum()));
        return utxos;
    }

    private static <T> String getDatumHash(T datum) {
        try {
            return Configuration.INSTANCE.getPlutusObjectConverter().toPlutusData(datum).getDatumHash();
        }
        catch (CborException | CborSerializationException e) {
            throw new CborRuntimeException((Exception)e);
        }
    }

    private static <T> String serializeDatumToHex(T datum) {
        return Configuration.INSTANCE.getPlutusObjectConverter().toPlutusData(datum).serializeToHex();
    }
}

