/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelector;
import com.bloxbean.cardano.client.common.CardanoConstants;
import com.bloxbean.cardano.client.function.MinAdaChecker;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.FeeCalculators;
import com.bloxbean.cardano.client.function.helper.MinAdaCheckers;
import com.bloxbean.cardano.client.function.helper.RedeemerUtil;
import com.bloxbean.cardano.client.transaction.spec.Redeemer;
import com.bloxbean.cardano.client.transaction.spec.RedeemerTag;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.Tuple;
import com.bloxbean.cardano.client.util.UtxoUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeOutputAdjustments {
    private static final Logger log = LoggerFactory.getLogger(ChangeOutputAdjustments.class);
    private static final int MAX_NO_RETRY_TO_ADJUST = 3;
    private static BigInteger changeSelectionBuffer = CardanoConstants.ONE_ADA.multiply(BigInteger.valueOf(2L));
    private static BigInteger DEFAULT_FEE = BigInteger.valueOf(17000L);

    public static TxBuilder adjustChangeOutput(String changeAddress) {
        return ChangeOutputAdjustments.adjustChangeOutput(changeAddress, changeAddress, 1);
    }

    public static TxBuilder adjustChangeOutput(String changeAddress, int noOfSigners) {
        return ChangeOutputAdjustments.adjustChangeOutput(changeAddress, changeAddress, noOfSigners);
    }

    public static TxBuilder adjustChangeOutput(String senderAddress, String changeAddress, int noOfSigners) {
        return (context, transaction) -> {
            int counter = 0;
            while (true) {
                MinAdaChecker minAdaChecker = MinAdaCheckers.minAdaChecker();
                List outputsWithLessAda = transaction.getBody().getOutputs().stream().filter(transactionOutput -> changeAddress.equals(transactionOutput.getAddress())).map(transactionOutput -> new Tuple(transactionOutput, (Object)((BigInteger)minAdaChecker.apply(context, transactionOutput)))).filter(tuple -> ((BigInteger)tuple._2).compareTo(BigInteger.ZERO) == 1).collect(Collectors.toList());
                if (outputsWithLessAda.size() == 0) break;
                if (outputsWithLessAda.size() > 1) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.valueOf(transaction.getBody().getOutputs()));
                    }
                    throw new TxBuildException("Multiple outputs found with same change address with less than min required ada. Can't balance. Please adjust output first.");
                }
                if (counter >= 3) {
                    throw new TxBuildException("Transaction rebalance failed. Max # of retry reached: " + counter);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Trying to adjust the change output. Retry # " + counter);
                }
                try {
                    ChangeOutputAdjustments.adjust(context, transaction, (TransactionOutput)((Tuple)outputsWithLessAda.get((int)0))._1, (BigInteger)((Tuple)outputsWithLessAda.get((int)0))._2, senderAddress, changeAddress);
                }
                catch (ApiException apiException) {
                    throw new ApiRuntimeException("Error in api call", (Exception)((Object)apiException));
                }
                FeeCalculators.feeCalculator(changeAddress, noOfSigners).apply(context, transaction);
                ++counter;
            }
        };
    }

    private static void adjust(TxBuilderContext context, Transaction transaction, TransactionOutput outputToAdjust, BigInteger additionalRequiredAmt, String senderAddress, String changeAddress) throws ApiException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(transaction);
        if (additionalRequiredAmt.compareTo(BigInteger.ZERO) == 0) {
            return;
        }
        List<Tuple> originalRedeemerTxnInputList = null;
        if (transaction.getWitnessSet().getRedeemers() != null && transaction.getWitnessSet().getRedeemers().size() > 0) {
            originalRedeemerTxnInputList = transaction.getWitnessSet().getRedeemers().stream().map(redeemer -> new Tuple(redeemer, (Object)RedeemerUtil.getScriptInputFromRedeemer(redeemer, transaction))).collect(Collectors.toList());
        }
        Set existingUtxos = transaction.getBody().getInputs().stream().map(ti -> Utxo.builder().txHash(ti.getTransactionId()).outputIndex(ti.getIndex()).build()).collect(Collectors.toSet());
        BigInteger totalRequiredWithBuffer = additionalRequiredAmt.add(changeSelectionBuffer);
        ArrayList<Utxo> newUtxos = new ArrayList<Utxo>();
        UtxoSelector utxoSelector = context.getUtxoSelector();
        Optional utxoOptional = utxoSelector.findFirst(senderAddress, utxo -> !existingUtxos.contains(utxo) && utxo.getAmount().size() == 1 && ((Amount)utxo.getAmount().get(0)).getQuantity().compareTo(totalRequiredWithBuffer) == 1);
        if (utxoOptional.isPresent()) {
            newUtxos.add((Utxo)utxoOptional.get());
        } else {
            List utxosFound = null;
            try {
                utxosFound = context.getUtxoSelectionStrategy().selectUtxos(senderAddress, "lovelace", totalRequiredWithBuffer, existingUtxos);
            }
            catch (ApiException ex) {
                utxosFound = context.getUtxoSelectionStrategy().selectUtxos(senderAddress, "lovelace", additionalRequiredAmt, existingUtxos);
            }
            if (utxosFound != null && utxosFound.size() > 0) {
                newUtxos.addAll(utxosFound);
            }
        }
        newUtxos.forEach(utxo -> {
            transaction.getBody().getInputs().add(new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex()));
            UtxoUtil.copyUtxoValuesToOutput((TransactionOutput)outputToAdjust, (Utxo)utxo);
        });
        BigInteger existingFee = transaction.getBody().getFee();
        Value changeOutputValue = outputToAdjust.getValue();
        changeOutputValue = changeOutputValue.plus(Value.builder().coin(existingFee).build());
        outputToAdjust.setValue(changeOutputValue);
        transaction.getBody().setFee(DEFAULT_FEE);
        if (originalRedeemerTxnInputList != null && originalRedeemerTxnInputList.size() > 0) {
            ArrayList redeemerList = new ArrayList();
            originalRedeemerTxnInputList.forEach(tuple -> {
                Redeemer redeemer = (Redeemer)tuple._1;
                TransactionInput input = (TransactionInput)tuple._2;
                int index = -1;
                if (redeemer.getTag() == RedeemerTag.Mint) {
                    index = 0;
                } else {
                    index = RedeemerUtil.getScriptInputIndex(input, transaction);
                    if (index == -1) {
                        throw new TxBuildException(String.format("Invalid redeemer index: %s, TransactionInput not found %s", index, input));
                    }
                }
                redeemer.setIndex(BigInteger.valueOf(index));
                redeemerList.add(redeemer);
            });
            transaction.getWitnessSet().setRedeemers(redeemerList);
        }
    }
}

