/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.plutus.spec.PlutusV1Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV2Script;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.AuxiliaryData;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MintCreators {
    public static TxBuilder mintCreator(Script script, MultiAsset multiAsset) {
        return MintCreators.mintCreator(script, multiAsset, false);
    }

    public static TxBuilder mintCreator(Script script, MultiAsset multiAsset, boolean inclScriptInAuxData) {
        Objects.requireNonNull(script);
        Objects.requireNonNull(multiAsset);
        return (context, transaction) -> {
            MintCreators.checkTransactionForNullValuesAndInitializeIfRequired(transaction, inclScriptInAuxData);
            if (transaction.getBody().getMint() == null) {
                transaction.getBody().setMint(List.of(multiAsset));
            } else {
                transaction.getBody().getMint().add(multiAsset);
            }
            if (inclScriptInAuxData) {
                if (script instanceof NativeScript) {
                    if (!transaction.getAuxiliaryData().getNativeScripts().contains(script)) {
                        transaction.getAuxiliaryData().getNativeScripts().add((NativeScript)script);
                    }
                } else if (script instanceof PlutusV1Script) {
                    if (!transaction.getAuxiliaryData().getPlutusV1Scripts().contains(script)) {
                        transaction.getAuxiliaryData().getPlutusV1Scripts().add((PlutusV1Script)script);
                    }
                } else if (script instanceof PlutusV2Script && !transaction.getAuxiliaryData().getPlutusV2Scripts().contains(script)) {
                    transaction.getAuxiliaryData().getPlutusV2Scripts().add((PlutusV2Script)script);
                }
            }
            if (script instanceof NativeScript) {
                if (!transaction.getWitnessSet().getNativeScripts().contains(script)) {
                    transaction.getWitnessSet().getNativeScripts().add((NativeScript)script);
                }
            } else if (script instanceof PlutusV1Script) {
                if (!transaction.getWitnessSet().getPlutusV1Scripts().contains(script)) {
                    transaction.getWitnessSet().getPlutusV1Scripts().add((PlutusV1Script)script);
                }
            } else if (script instanceof PlutusV2Script && !transaction.getWitnessSet().getPlutusV2Scripts().contains(script)) {
                transaction.getWitnessSet().getPlutusV2Scripts().add((PlutusV2Script)script);
            }
        };
    }

    private static void checkTransactionForNullValuesAndInitializeIfRequired(Transaction transaction, boolean inclScriptToAuxData) {
        if (inclScriptToAuxData) {
            AuxiliaryData auxiliaryData = transaction.getAuxiliaryData();
            if (auxiliaryData == null) {
                transaction.setAuxiliaryData(new AuxiliaryData());
                auxiliaryData = transaction.getAuxiliaryData();
            }
            if (auxiliaryData.getNativeScripts() == null) {
                auxiliaryData.setNativeScripts(new ArrayList());
            }
        }
        if (transaction.getWitnessSet() == null) {
            transaction.setWitnessSet(new TransactionWitnessSet());
        }
        if (transaction.getWitnessSet().getNativeScripts() == null) {
            transaction.getWitnessSet().setNativeScripts(new ArrayList());
        }
    }
}

