/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.UtxoUtil;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class CollateralBuilders {
    public static TxBuilder collateralFrom(List<Utxo> utxos) {
        return (context, transaction) -> {
            CollateralBuilders.checkTransactionBodyForNull(transaction);
            utxos.forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                transaction.getBody().getCollateral().add(input);
            });
        };
    }

    public static TxBuilder collateralFrom(Supplier<List<Utxo>> supplier) {
        return (context, transaction) -> {
            CollateralBuilders.checkTransactionBodyForNull(transaction);
            ((List)supplier.get()).forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                transaction.getBody().getCollateral().add(input);
            });
        };
    }

    public static TxBuilder collateralFrom(String txHash, int txIndex) {
        return (context, transaction) -> {
            CollateralBuilders.checkTransactionBodyForNull(transaction);
            TransactionInput input = TransactionInput.builder().transactionId(txHash).index(txIndex).build();
            transaction.getBody().getCollateral().add(input);
        };
    }

    public static TxBuilder collateralOutputs(String collateralReturnAddress, List<Utxo> utxos) {
        return (context, transaction) -> {
            CollateralBuilders.checkTransactionBodyForNull(transaction);
            TransactionOutput collateralOutput = TransactionOutput.builder().address(collateralReturnAddress).value(Value.builder().coin(BigInteger.ZERO).build()).build();
            utxos.forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                transaction.getBody().getCollateral().add(input);
                UtxoUtil.copyUtxoValuesToOutput((TransactionOutput)collateralOutput, (Utxo)utxo);
            });
            transaction.getBody().setCollateralReturn(collateralOutput);
            transaction.getBody().setTotalCollateral(BigInteger.valueOf(1000000L));
        };
    }

    public static TxBuilder balanceCollateralOutputs() {
        return (context, transaction) -> {
            BigDecimal collateralPercent = context.getProtocolParams().getCollateralPercent();
            BigInteger totalCollateral = new BigDecimal(transaction.getBody().getFee()).multiply(collateralPercent.divide(BigDecimal.valueOf(100L))).setScale(0, RoundingMode.CEILING).toBigInteger();
            TransactionOutput collateralReturn = transaction.getBody().getCollateralReturn();
            if (collateralReturn == null) {
                throw new TxBuildException("Unable to do balance. No collateral output found");
            }
            BigInteger remainingCoin = collateralReturn.getValue().getCoin().subtract(totalCollateral);
            Value newValue = collateralReturn.getValue().toBuilder().coin(remainingCoin).build();
            TransactionOutput balancedCollateralReturn = collateralReturn.toBuilder().value(newValue).build();
            transaction.getBody().setCollateralReturn(balancedCollateralReturn);
            transaction.getBody().setTotalCollateral(totalCollateral);
        };
    }

    private static void checkTransactionBodyForNull(Transaction transaction) {
        if (transaction.getBody() == null) {
            transaction.setBody(new TransactionBody());
        }
        if (transaction.getBody().getInputs() == null) {
            transaction.getBody().setInputs(new ArrayList());
        }
        if (transaction.getBody().getCollateral() == null) {
            transaction.getBody().setCollateral(new ArrayList());
        }
    }
}

