/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.function.MinAdaChecker;
import com.bloxbean.cardano.client.function.Output;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.TxOutputBuilder;
import com.bloxbean.cardano.client.function.helper.MinAdaCheckers;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class OutputBuilders {
    public static TxOutputBuilder createFromOutput(Output output) {
        return OutputBuilders.createFromOutput(output, false, null);
    }

    public static TxOutputBuilder createFromMintOutput(Output output) {
        return OutputBuilders.createFromOutput(output, true, null);
    }

    public static TxOutputBuilder createFromOutput(Output output, boolean isMintOutput, MinAdaChecker minAdaChecker) {
        return (context, outputs) -> {
            Objects.requireNonNull(output);
            Objects.requireNonNull(output.getAddress());
            if ("lovelace".equals(output.getAssetName()) && (output.getPolicyId() == null || output.getPolicyId().isEmpty())) {
                OutputBuilders.handleLovelaceOutput(output, minAdaChecker, context, outputs);
            } else {
                OutputBuilders.handleMultiAssetOutput(output, minAdaChecker, context, outputs, isMintOutput);
            }
        };
    }

    public static TxOutputBuilder createFromOutput(TransactionOutput txnOutput) {
        return OutputBuilders.createFromOutput(txnOutput, false, null);
    }

    public static TxOutputBuilder createFromMintOutput(TransactionOutput txnOutput) {
        return OutputBuilders.createFromOutput(txnOutput, true, null);
    }

    public static TxOutputBuilder createFromOutput(TransactionOutput txnOutput, boolean isMintOutput, MinAdaChecker minAdaChecker) {
        return (context, outputs) -> {
            Objects.requireNonNull(txnOutput);
            Objects.requireNonNull(txnOutput.getAddress());
            Objects.requireNonNull(txnOutput.getValue());
            String address = txnOutput.getAddress();
            Value value = txnOutput.getValue();
            if (isMintOutput) {
                List multiAssets = value.getMultiAssets();
                Objects.requireNonNull(multiAssets);
                multiAssets.stream().forEach(context::addMintMultiAsset);
            }
            if (context.isMergeOutputs()) {
                outputs.stream().filter(to -> address.equals(to.getAddress())).findFirst().ifPresentOrElse(to -> {
                    Value newValue = to.getValue().plus(value);
                    to.setValue(newValue);
                    OutputBuilders.copyDatumAndScriptRef(txnOutput, to);
                    OutputBuilders.checkIfMinAdaIsThere(context, to, minAdaChecker);
                }, () -> {
                    TransactionOutput output = new TransactionOutput(address, value);
                    OutputBuilders.copyDatumAndScriptRef(txnOutput, output);
                    OutputBuilders.checkIfMinAdaIsThere(context, output, minAdaChecker);
                    outputs.add(output);
                });
            } else {
                TransactionOutput output = new TransactionOutput(address, value);
                OutputBuilders.copyDatumAndScriptRef(txnOutput, output);
                OutputBuilders.checkIfMinAdaIsThere(context, output, minAdaChecker);
                outputs.add(output);
            }
        };
    }

    private static void handleMultiAssetOutput(Output output, MinAdaChecker minAdaChecker, TxBuilderContext tc, List<TransactionOutput> outputs, boolean isMintOutput) {
        Asset asset = new Asset(output.getAssetName(), output.getQty());
        MultiAsset multiAsset = new MultiAsset(output.getPolicyId(), List.of(asset));
        if (isMintOutput) {
            tc.addMintMultiAsset(multiAsset);
        }
        if (tc.isMergeOutputs()) {
            outputs.stream().filter(to -> output.getAddress().equals(to.getAddress())).findFirst().ifPresentOrElse(to -> {
                Value newValue = to.getValue().plus(new Value(BigInteger.ZERO, List.of(multiAsset)));
                to.setValue(newValue);
                OutputBuilders.copyDatumAndScriptRef(output, to);
                OutputBuilders.checkIfMinAdaIsThere(tc, to, minAdaChecker);
            }, () -> {
                TransactionOutput to = new TransactionOutput(output.getAddress(), new Value(BigInteger.ZERO, List.of(multiAsset)));
                OutputBuilders.copyDatumAndScriptRef(output, to);
                OutputBuilders.checkIfMinAdaIsThere(tc, to, minAdaChecker);
                outputs.add(to);
            });
        } else {
            TransactionOutput to2 = new TransactionOutput(output.getAddress(), new Value(BigInteger.ZERO, List.of(multiAsset)));
            OutputBuilders.copyDatumAndScriptRef(output, to2);
            OutputBuilders.checkIfMinAdaIsThere(tc, to2, minAdaChecker);
            outputs.add(to2);
        }
    }

    private static void handleLovelaceOutput(Output output, MinAdaChecker minAdaChecker, TxBuilderContext tc, List<TransactionOutput> outputs) {
        if (tc.isMergeOutputs()) {
            outputs.stream().filter(to -> output.getAddress().equals(to.getAddress())).findFirst().ifPresentOrElse(to -> {
                BigInteger newCoinAmt = to.getValue().getCoin().add(output.getQty());
                to.getValue().setCoin(newCoinAmt);
                OutputBuilders.copyDatumAndScriptRef(output, to);
                OutputBuilders.checkIfMinAdaIsThere(tc, to, minAdaChecker);
            }, () -> {
                TransactionOutput to = new TransactionOutput(output.getAddress(), new Value(output.getQty(), new ArrayList()));
                OutputBuilders.copyDatumAndScriptRef(output, to);
                OutputBuilders.checkIfMinAdaIsThere(tc, to, minAdaChecker);
                outputs.add(to);
            });
        } else {
            TransactionOutput to2 = new TransactionOutput(output.getAddress(), new Value(output.getQty(), new ArrayList()));
            OutputBuilders.copyDatumAndScriptRef(output, to2);
            OutputBuilders.checkIfMinAdaIsThere(tc, to2, minAdaChecker);
            outputs.add(to2);
        }
    }

    private static void copyDatumAndScriptRef(Output output, TransactionOutput to) {
        if (output.getDatum() != null && to.getDatumHash() == null && to.getInlineDatum() == null) {
            if (output.isInlineDatum()) {
                to.setInlineDatum(output.getDatum());
            } else {
                to.setDatumHash(output.getDatum().getDatumHashAsBytes());
            }
        }
        if (output.getScriptRef() != null && to.getScriptRef() == null) {
            to.setScriptRef(output.getScriptRef());
        }
    }

    private static void copyDatumAndScriptRef(TransactionOutput fromOutput, TransactionOutput toOutput) {
        if (fromOutput.getDatumHash() != null && fromOutput.getDatumHash().length > 0 && toOutput.getDatumHash() == null) {
            toOutput.setDatumHash(fromOutput.getDatumHash());
        }
        if (fromOutput.getInlineDatum() != null && toOutput.getInlineDatum() == null) {
            toOutput.setInlineDatum(fromOutput.getInlineDatum());
        }
        if (fromOutput.getScriptRef() != null && toOutput.getScriptRef() == null) {
            toOutput.setScriptRef(fromOutput.getScriptRef());
        }
    }

    private static void checkIfMinAdaIsThere(TxBuilderContext tc, TransactionOutput output, MinAdaChecker minAdaChecker) {
        BigInteger additionalLovelace = minAdaChecker != null ? (BigInteger)minAdaChecker.apply(tc, output) : (BigInteger)MinAdaCheckers.minAdaChecker().apply(tc, output);
        if (additionalLovelace != null && additionalLovelace.compareTo(BigInteger.ZERO) == 1) {
            Value orginalValue = output.getValue();
            Value newValue = orginalValue.plus(Value.builder().coin(additionalLovelace).build());
            output.setValue(newValue);
        }
    }
}

