/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Try;
import java.util.List;
import java.util.Set;

public class DuplicateScriptWitnessChecker {
    public static TxBuilder removeDuplicateScriptWitnesses() {
        return (context, txn) -> {
            Set<String> refScriptHashes = context.getRefScriptHashes();
            if (refScriptHashes != null && !refScriptHashes.isEmpty()) {
                DuplicateScriptWitnessChecker.removeDuplicateScripts(txn.getWitnessSet().getNativeScripts(), refScriptHashes);
                DuplicateScriptWitnessChecker.removeDuplicateScripts(txn.getWitnessSet().getPlutusV1Scripts(), refScriptHashes);
                DuplicateScriptWitnessChecker.removeDuplicateScripts(txn.getWitnessSet().getPlutusV2Scripts(), refScriptHashes);
                DuplicateScriptWitnessChecker.removeDuplicateScripts(txn.getWitnessSet().getPlutusV3Scripts(), refScriptHashes);
            }
        };
    }

    private static void removeDuplicateScripts(List<? extends Script> scripts, Set<String> refScriptHashes) {
        if (scripts == null || scripts.isEmpty()) {
            return;
        }
        scripts.removeIf(plutusScript -> (Boolean)Try.of(() -> refScriptHashes.contains(HexUtil.encodeHexString((byte[])plutusScript.getScriptHash()))).getOrElse((Object)false));
    }
}

