/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.ScriptSupplier;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.helper.FeeCalculationService;
import com.bloxbean.cardano.client.api.util.ReferenceScriptUtil;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.helper.ScriptDataHashCalculator;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.transaction.util.TransactionUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeeCalculators {
    private static final Logger log = LoggerFactory.getLogger(FeeCalculators.class);
    private static Account dummyAccount;

    public static TxBuilder feeCalculator(String changeAddress, int noOfSigners) {
        return (transactionContext, transaction) -> FeeCalculators.execute(transactionContext, transaction, changeAddress, noOfSigners, null);
    }

    public static TxBuilder feeCalculator(int noOfSigners, UpdateOutputFunction updateOutputWithFeeFunc) {
        return (transactionContext, transaction) -> FeeCalculators.execute(transactionContext, transaction, null, noOfSigners, updateOutputWithFeeFunc);
    }

    private static void execute(TxBuilderContext context, Transaction transaction, String changeAddress, int noOfSigners, UpdateOutputFunction updateOutputWithFeeFunc) {
        FeeCalculationService feeCalculationService = context.getFeeCalculationService();
        ScriptDataHashCalculator.calculateScriptDataHash(context, transaction);
        try {
            List exUnits;
            List redeemerList;
            TransactionBody tbody = transaction.getBody();
            Transaction clonedTxn = FeeCalculators.createTransactionWithDummyWitnesses(transaction, noOfSigners);
            BigInteger baseFee = feeCalculationService.calculateFee(clonedTxn);
            BigInteger scriptFee = BigInteger.ZERO;
            if (transaction.getWitnessSet() != null && (redeemerList = transaction.getWitnessSet().getRedeemers()) != null && redeemerList.size() > 0 && (exUnits = redeemerList.stream().map(redeemer -> redeemer.getExUnits()).collect(Collectors.toList())) != null) {
                scriptFee = feeCalculationService.calculateScriptFee(exUnits);
            }
            long totalRefScriptBytesInInputs = 0L;
            if (transaction.getBody().getScriptDataHash() != null && context.getUtxos() != null) {
                Set inputWithScriptRefToBeFetched = context.getUtxos().stream().filter(utxo -> utxo.getReferenceScriptHash() != null).filter(utxo -> context.getRefScript(utxo.getReferenceScriptHash()).isEmpty()).map(utxo -> new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex())).collect(Collectors.toSet());
                long inputRefScriptSize = context.getUtxos().stream().filter(utxo -> utxo.getReferenceScriptHash() != null).flatMap(utxo -> context.getRefScript(utxo.getReferenceScriptHash()).stream()).mapToLong(bytes -> ((byte[])bytes).length).sum();
                totalRefScriptBytesInInputs = inputWithScriptRefToBeFetched != null && inputWithScriptRefToBeFetched.size() > 0 ? inputRefScriptSize + ReferenceScriptUtil.totalRefScriptsSizeInInputs((UtxoSupplier)context.getUtxoSupplier(), (ScriptSupplier)context.getScriptSupplier(), inputWithScriptRefToBeFetched) : inputRefScriptSize;
            }
            BigInteger refScriptFee = BigInteger.ZERO;
            if (transaction.getBody().getReferenceInputs() != null && transaction.getBody().getReferenceInputs().size() > 0) {
                List<byte[]> refScripts = context.getRefScripts();
                if (refScripts == null || refScripts.size() == 0) {
                    if (context.getScriptSupplier() != null) {
                        long totalRefScriptsBytes = ReferenceScriptUtil.totalRefScriptsSizeInRefInputs((UtxoSupplier)context.getUtxoSupplier(), (ScriptSupplier)context.getScriptSupplier(), (Transaction)transaction);
                        refScriptFee = feeCalculationService.tierRefScriptFee(totalRefScriptsBytes + totalRefScriptBytesInInputs);
                    } else {
                        log.debug("Script supplier is required to calculate reference script fee. Alternatively, you can set reference scripts during building the transaction.");
                    }
                } else {
                    int totalRefScriptBytes = refScripts.stream().mapToInt(byteArray -> ((byte[])byteArray).length).sum();
                    refScriptFee = feeCalculationService.tierRefScriptFee((long)totalRefScriptBytes + totalRefScriptBytesInInputs);
                }
            } else if (totalRefScriptBytesInInputs > 0L) {
                refScriptFee = feeCalculationService.tierRefScriptFee(totalRefScriptBytesInInputs);
            }
            BigInteger totalFee = baseFee.add(scriptFee).add(refScriptFee);
            tbody.setFee(totalFee);
            if (updateOutputWithFeeFunc == null) {
                Optional<TransactionOutput> changeOutput = tbody.getOutputs().stream().filter(output -> changeAddress.equals(output.getAddress()) && output.getValue().getCoin().compareTo(BigInteger.ZERO) < 0).findFirst();
                if (!changeOutput.isPresent()) {
                    changeOutput = tbody.getOutputs().stream().filter(output -> changeAddress.equals(output.getAddress())).max((to1, to2) -> to1.getValue().getCoin().compareTo(to2.getValue().getCoin()));
                }
                changeOutput.ifPresentOrElse(output -> output.getValue().setCoin(output.getValue().getCoin().subtract(totalFee)), () -> {
                    Value value = new Value(BigInteger.ZERO.subtract(totalFee), new ArrayList());
                    TransactionOutput output = new TransactionOutput(changeAddress, value);
                    transaction.getBody().getOutputs().add(output);
                });
            } else {
                updateOutputWithFeeFunc.accept(totalFee, transaction.getBody().getOutputs());
            }
        }
        catch (ApiException apiException) {
            throw new ApiRuntimeException("Error in fee calculation", (Exception)((Object)apiException));
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException("Error in fee calculation", (Exception)((Object)e));
        }
    }

    private static Transaction createTransactionWithDummyWitnesses(Transaction transaction, int noOfSigners) {
        BigInteger orginalFee = transaction.getBody().getFee();
        transaction.getBody().setFee(BigInteger.valueOf(170000L));
        Transaction cloneTxn = TransactionUtil.createCopy((Transaction)transaction);
        transaction.getBody().setFee(orginalFee);
        for (int i = 0; i < noOfSigners; ++i) {
            cloneTxn = FeeCalculators.getDummyAccount().sign(cloneTxn);
        }
        return cloneTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Account getDummyAccount() {
        if (dummyAccount != null) return dummyAccount;
        Class<FeeCalculators> clazz = FeeCalculators.class;
        synchronized (FeeCalculators.class) {
            if (dummyAccount != null) return dummyAccount;
            dummyAccount = new Account(Networks.testnet());
            // ** MonitorExit[var0] (shouldn't be in output)
            return dummyAccount;
        }
    }

    public static interface UpdateOutputFunction
    extends BiConsumer<BigInteger, List<TransactionOutput>> {
        @Override
        public void accept(BigInteger var1, List<TransactionOutput> var2);
    }
}

