/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;

public class MintUtil {
    public static List<MultiAsset> getSortedMultiAssets(@NonNull List<MultiAsset> multiAssets) {
        if (multiAssets == null) {
            throw new NullPointerException("multiAssets is marked non-null but is null");
        }
        List<MultiAsset> copyMultiAssets = multiAssets.stream().collect(Collectors.toList());
        copyMultiAssets.sort(Comparator.comparing(MultiAsset::getPolicyId));
        return copyMultiAssets;
    }

    public static int getIndexByPolicyId(@NonNull List<MultiAsset> multiAssets, @NonNull String policyId) {
        if (multiAssets == null) {
            throw new NullPointerException("multiAssets is marked non-null but is null");
        }
        if (policyId == null) {
            throw new NullPointerException("policyId is marked non-null but is null");
        }
        return IntStream.range(0, multiAssets.size()).filter(i -> policyId.equals(((MultiAsset)multiAssets.get(i)).getPolicyId())).findFirst().orElse(-1);
    }
}

