/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.function.TxSigner;
import com.bloxbean.cardano.client.transaction.TransactionSigner;
import com.bloxbean.cardano.client.transaction.spec.Policy;
import com.bloxbean.cardano.client.transaction.spec.Transaction;

public class SignerProviders {
    public static TxSigner signerFrom(Account ... signers) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.sign(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner signerFrom(SecretKey ... secretKeys) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (SecretKey sk : secretKeys) {
                outputTxn = TransactionSigner.INSTANCE.sign(outputTxn, sk);
            }
            return outputTxn;
        };
    }

    public static TxSigner signerFrom(Policy ... policies) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (Policy policy : policies) {
                for (SecretKey sk : policy.getPolicyKeys()) {
                    outputTxn = TransactionSigner.INSTANCE.sign(outputTxn, sk);
                }
            }
            return outputTxn;
        };
    }

    public static TxSigner signerFrom(HdKeyPair ... hdKeyPairs) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (HdKeyPair hdKeyPair : hdKeyPairs) {
                outputTxn = TransactionSigner.INSTANCE.sign(outputTxn, hdKeyPair);
            }
            return outputTxn;
        };
    }

    public static TxSigner stakeKeySignerFrom(Account ... signers) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithStakeKey(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner drepKeySignerFrom(Account ... signers) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithDRepKey(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner committeeColdKeySignerFrom(Account ... signers) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithCommitteeColdKey(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner committeeHotKeySignerFrom(Account ... signers) {
        return transaction -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithCommitteeHotKey(outputTxn);
            }
            return outputTxn;
        };
    }
}

