/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function;

import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.ScriptSupplier;
import com.bloxbean.cardano.client.api.TransactionEvaluator;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.helper.FeeCalculationService;
import com.bloxbean.cardano.client.api.helper.TransactionBuilder;
import com.bloxbean.cardano.client.api.helper.impl.FeeCalculationServiceImpl;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.UtxoSelector;
import com.bloxbean.cardano.client.coinselection.impl.DefaultUtxoSelectionStrategyImpl;
import com.bloxbean.cardano.client.coinselection.impl.DefaultUtxoSelector;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxSigner;
import com.bloxbean.cardano.client.plutus.spec.CostMdls;
import com.bloxbean.cardano.client.plutus.spec.Language;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TxBuilderContext {
    private UtxoSupplier utxoSupplier;
    private ProtocolParams protocolParams;
    private ScriptSupplier scriptSupplier;
    private UtxoSelectionStrategy utxoSelectionStrategy;
    private UtxoSelector utxoSelector;
    private FeeCalculationService feeCalculationService;
    private TransactionEvaluator transactionEvaluator;
    private CostMdls costMdls;
    private List<MultiAsset> mintMultiAssets = new ArrayList<MultiAsset>();
    private Set<Utxo> utxos = new HashSet<Utxo>();
    private Map<String, Tuple<PlutusScript, byte[]>> refScripts = new HashMap<String, Tuple<PlutusScript, byte[]>>();
    private boolean mergeOutputs = true;
    private Era serializationEra;

    public TxBuilderContext(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier) {
        this(utxoSupplier, protocolParamsSupplier.getProtocolParams());
    }

    public TxBuilderContext(UtxoSupplier utxoSupplier, ProtocolParams protocolParams) {
        this.utxoSupplier = utxoSupplier;
        this.protocolParams = protocolParams;
        this.utxoSelectionStrategy = new DefaultUtxoSelectionStrategyImpl(utxoSupplier);
        this.utxoSelector = new DefaultUtxoSelector(utxoSupplier);
        this.feeCalculationService = new FeeCalculationServiceImpl(new TransactionBuilder(utxoSupplier, () -> protocolParams));
    }

    public TxBuilderContext setScriptSupplier(ScriptSupplier scriptSupplier) {
        this.scriptSupplier = scriptSupplier;
        return this;
    }

    public ScriptSupplier getScriptSupplier() {
        return this.scriptSupplier;
    }

    public TxBuilderContext setUtxoSelectionStrategy(UtxoSelectionStrategy utxoSelectionStrategy) {
        this.utxoSelectionStrategy = utxoSelectionStrategy;
        return this;
    }

    public UtxoSelectionStrategy getUtxoSelectionStrategy() {
        return this.utxoSelectionStrategy;
    }

    public TxBuilderContext setUtxoSelector(UtxoSelector utxoSelector) {
        this.utxoSelector = utxoSelector;
        return this;
    }

    public UtxoSelector getUtxoSelector() {
        return this.utxoSelector;
    }

    public ProtocolParams getProtocolParams() {
        return this.protocolParams;
    }

    public void addMintMultiAsset(MultiAsset multiAsset) {
        this.mintMultiAssets = MultiAsset.mergeMultiAssetLists(this.mintMultiAssets, List.of(multiAsset));
    }

    public List<MultiAsset> getMintMultiAssets() {
        return this.mintMultiAssets;
    }

    public void clearMintMultiAssets() {
        this.mintMultiAssets.clear();
    }

    public TxBuilderContext withTxnEvaluator(TransactionEvaluator transactionEvaluator) {
        this.transactionEvaluator = transactionEvaluator;
        return this;
    }

    public TransactionEvaluator getTxnEvaluator() {
        return this.transactionEvaluator;
    }

    public TxBuilderContext withCostMdls(CostMdls costMdls) {
        this.costMdls = costMdls;
        return this;
    }

    public TxBuilderContext mergeOutputs(boolean mergeOutputs) {
        this.mergeOutputs = mergeOutputs;
        return this;
    }

    public TxBuilderContext withSerializationEra(Era era) {
        this.serializationEra = era;
        return this;
    }

    public Era getSerializationEra() {
        return this.serializationEra;
    }

    @Deprecated(since="0.4.3", forRemoval=true)
    public void setCostMdls(CostMdls costMdls) {
        this.withCostMdls(costMdls);
    }

    public void addUtxo(Utxo utxo) {
        this.utxos.add(utxo);
    }

    public Set<Utxo> getUtxos() {
        return this.utxos;
    }

    public void clearUtxos() {
        this.utxos.clear();
    }

    public void addRefScripts(PlutusScript plutusScript) {
        this.refScripts.put(HexUtil.encodeHexString((byte[])plutusScript.getScriptHash()), (Tuple<PlutusScript, byte[]>)new Tuple((Object)plutusScript, (Object)plutusScript.scriptRefBytes()));
    }

    public Optional<byte[]> getRefScript(String scriptHash) {
        Tuple<PlutusScript, byte[]> tuple = this.refScripts.get(scriptHash);
        return tuple != null ? Optional.of((byte[])tuple._2) : Optional.empty();
    }

    public List<byte[]> getRefScripts() {
        return this.refScripts.values().stream().map(tuple -> (byte[])tuple._2).collect(Collectors.toList());
    }

    public List<PlutusScript> getRefPlutusScripts() {
        return this.refScripts.values().stream().map(tuple -> (PlutusScript)tuple._1).collect(Collectors.toList());
    }

    public Set<String> getRefScriptHashes() {
        Set refScriptInUtxos = this.utxos.stream().filter(utxo -> utxo.getReferenceScriptHash() != null).map(utxo -> utxo.getReferenceScriptHash()).collect(Collectors.toSet());
        HashSet<String> hashes = new HashSet<String>();
        hashes.addAll(this.refScripts.keySet());
        hashes.addAll(refScriptInUtxos);
        return hashes;
    }

    public List<Language> getRefScriptLanguages() {
        if (this.refScripts.size() == 0) {
            return Collections.emptyList();
        }
        return this.refScripts.values().stream().map(tuple -> ((PlutusScript)tuple._1).getLanguage()).collect(Collectors.toSet()).stream().sorted(Comparator.comparing(Language::getKey)).collect(Collectors.toList());
    }

    public void clearRefScripts() {
        this.refScripts.clear();
    }

    public static TxBuilderContext init(UtxoSupplier utxoSupplier, ProtocolParams protocolParams) {
        return new TxBuilderContext(utxoSupplier, protocolParams);
    }

    public static TxBuilderContext init(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier) {
        return new TxBuilderContext(utxoSupplier, protocolParamsSupplier);
    }

    public Transaction build(TxBuilder txBuilder) {
        Transaction transaction = new Transaction();
        transaction.setEra(this.getSerializationEra());
        txBuilder.apply(this, transaction);
        this.clearTempStates();
        return transaction;
    }

    public Transaction buildAndSign(TxBuilder txBuilder, TxSigner signer) {
        Transaction transaction = this.build(txBuilder);
        return signer.sign(transaction);
    }

    public void build(Transaction transaction, TxBuilder txBuilder) {
        txBuilder.apply(this, transaction);
        this.clearTempStates();
    }

    private void clearTempStates() {
        this.clearMintMultiAssets();
        this.clearUtxos();
        this.clearRefScripts();
    }

    public UtxoSupplier getUtxoSupplier() {
        return this.utxoSupplier;
    }

    public FeeCalculationService getFeeCalculationService() {
        return this.feeCalculationService;
    }

    public TransactionEvaluator getTransactionEvaluator() {
        return this.transactionEvaluator;
    }

    public CostMdls getCostMdls() {
        return this.costMdls;
    }

    public boolean isMergeOutputs() {
        return this.mergeOutputs;
    }

    public void setUtxoSupplier(UtxoSupplier utxoSupplier) {
        this.utxoSupplier = utxoSupplier;
    }

    public void setProtocolParams(ProtocolParams protocolParams) {
        this.protocolParams = protocolParams;
    }

    public void setFeeCalculationService(FeeCalculationService feeCalculationService) {
        this.feeCalculationService = feeCalculationService;
    }

    public void setTransactionEvaluator(TransactionEvaluator transactionEvaluator) {
        this.transactionEvaluator = transactionEvaluator;
    }

    public void setMintMultiAssets(List<MultiAsset> mintMultiAssets) {
        this.mintMultiAssets = mintMultiAssets;
    }

    public void setUtxos(Set<Utxo> utxos) {
        this.utxos = utxos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxBuilderContext)) {
            return false;
        }
        TxBuilderContext other = (TxBuilderContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMergeOutputs() != other.isMergeOutputs()) {
            return false;
        }
        UtxoSupplier this$utxoSupplier = this.getUtxoSupplier();
        UtxoSupplier other$utxoSupplier = other.getUtxoSupplier();
        if (this$utxoSupplier == null ? other$utxoSupplier != null : !this$utxoSupplier.equals(other$utxoSupplier)) {
            return false;
        }
        ProtocolParams this$protocolParams = this.getProtocolParams();
        ProtocolParams other$protocolParams = other.getProtocolParams();
        if (this$protocolParams == null ? other$protocolParams != null : !this$protocolParams.equals(other$protocolParams)) {
            return false;
        }
        ScriptSupplier this$scriptSupplier = this.getScriptSupplier();
        ScriptSupplier other$scriptSupplier = other.getScriptSupplier();
        if (this$scriptSupplier == null ? other$scriptSupplier != null : !this$scriptSupplier.equals(other$scriptSupplier)) {
            return false;
        }
        UtxoSelectionStrategy this$utxoSelectionStrategy = this.getUtxoSelectionStrategy();
        UtxoSelectionStrategy other$utxoSelectionStrategy = other.getUtxoSelectionStrategy();
        if (this$utxoSelectionStrategy == null ? other$utxoSelectionStrategy != null : !this$utxoSelectionStrategy.equals(other$utxoSelectionStrategy)) {
            return false;
        }
        UtxoSelector this$utxoSelector = this.getUtxoSelector();
        UtxoSelector other$utxoSelector = other.getUtxoSelector();
        if (this$utxoSelector == null ? other$utxoSelector != null : !this$utxoSelector.equals(other$utxoSelector)) {
            return false;
        }
        FeeCalculationService this$feeCalculationService = this.getFeeCalculationService();
        FeeCalculationService other$feeCalculationService = other.getFeeCalculationService();
        if (this$feeCalculationService == null ? other$feeCalculationService != null : !this$feeCalculationService.equals(other$feeCalculationService)) {
            return false;
        }
        TransactionEvaluator this$transactionEvaluator = this.getTransactionEvaluator();
        TransactionEvaluator other$transactionEvaluator = other.getTransactionEvaluator();
        if (this$transactionEvaluator == null ? other$transactionEvaluator != null : !this$transactionEvaluator.equals(other$transactionEvaluator)) {
            return false;
        }
        CostMdls this$costMdls = this.getCostMdls();
        CostMdls other$costMdls = other.getCostMdls();
        if (this$costMdls == null ? other$costMdls != null : !this$costMdls.equals(other$costMdls)) {
            return false;
        }
        List<MultiAsset> this$mintMultiAssets = this.getMintMultiAssets();
        List<MultiAsset> other$mintMultiAssets = other.getMintMultiAssets();
        if (this$mintMultiAssets == null ? other$mintMultiAssets != null : !((Object)this$mintMultiAssets).equals(other$mintMultiAssets)) {
            return false;
        }
        Set<Utxo> this$utxos = this.getUtxos();
        Set<Utxo> other$utxos = other.getUtxos();
        if (this$utxos == null ? other$utxos != null : !((Object)this$utxos).equals(other$utxos)) {
            return false;
        }
        List<byte[]> this$refScripts = this.getRefScripts();
        List<byte[]> other$refScripts = other.getRefScripts();
        if (this$refScripts == null ? other$refScripts != null : !((Object)this$refScripts).equals(other$refScripts)) {
            return false;
        }
        Era this$serializationEra = this.getSerializationEra();
        Era other$serializationEra = other.getSerializationEra();
        return !(this$serializationEra == null ? other$serializationEra != null : !this$serializationEra.equals(other$serializationEra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxBuilderContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMergeOutputs() ? 79 : 97);
        UtxoSupplier $utxoSupplier = this.getUtxoSupplier();
        result = result * 59 + ($utxoSupplier == null ? 43 : $utxoSupplier.hashCode());
        ProtocolParams $protocolParams = this.getProtocolParams();
        result = result * 59 + ($protocolParams == null ? 43 : $protocolParams.hashCode());
        ScriptSupplier $scriptSupplier = this.getScriptSupplier();
        result = result * 59 + ($scriptSupplier == null ? 43 : $scriptSupplier.hashCode());
        UtxoSelectionStrategy $utxoSelectionStrategy = this.getUtxoSelectionStrategy();
        result = result * 59 + ($utxoSelectionStrategy == null ? 43 : $utxoSelectionStrategy.hashCode());
        UtxoSelector $utxoSelector = this.getUtxoSelector();
        result = result * 59 + ($utxoSelector == null ? 43 : $utxoSelector.hashCode());
        FeeCalculationService $feeCalculationService = this.getFeeCalculationService();
        result = result * 59 + ($feeCalculationService == null ? 43 : $feeCalculationService.hashCode());
        TransactionEvaluator $transactionEvaluator = this.getTransactionEvaluator();
        result = result * 59 + ($transactionEvaluator == null ? 43 : $transactionEvaluator.hashCode());
        CostMdls $costMdls = this.getCostMdls();
        result = result * 59 + ($costMdls == null ? 43 : $costMdls.hashCode());
        List<MultiAsset> $mintMultiAssets = this.getMintMultiAssets();
        result = result * 59 + ($mintMultiAssets == null ? 43 : ((Object)$mintMultiAssets).hashCode());
        Set<Utxo> $utxos = this.getUtxos();
        result = result * 59 + ($utxos == null ? 43 : ((Object)$utxos).hashCode());
        List<byte[]> $refScripts = this.getRefScripts();
        result = result * 59 + ($refScripts == null ? 43 : ((Object)$refScripts).hashCode());
        Era $serializationEra = this.getSerializationEra();
        result = result * 59 + ($serializationEra == null ? 43 : $serializationEra.hashCode());
        return result;
    }

    public String toString() {
        return "TxBuilderContext(utxoSupplier=" + this.getUtxoSupplier() + ", protocolParams=" + this.getProtocolParams() + ", scriptSupplier=" + this.getScriptSupplier() + ", utxoSelectionStrategy=" + this.getUtxoSelectionStrategy() + ", utxoSelector=" + this.getUtxoSelector() + ", feeCalculationService=" + this.getFeeCalculationService() + ", transactionEvaluator=" + this.getTransactionEvaluator() + ", costMdls=" + this.getCostMdls() + ", mintMultiAssets=" + this.getMintMultiAssets() + ", utxos=" + this.getUtxos() + ", refScripts=" + this.getRefScripts() + ", mergeOutputs=" + this.isMergeOutputs() + ", serializationEra=" + this.getSerializationEra() + ")";
    }
}

