/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.api.TransactionEvaluator;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.EvaluationResult;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import java.util.List;

public class ScriptCostEvaluators {
    public static TxBuilder evaluateScriptCost() {
        return (ctx, transaction) -> {
            if (transaction.getWitnessSet().getRedeemers() == null || transaction.getWitnessSet().getRedeemers().isEmpty()) {
                return;
            }
            TransactionEvaluator transactionEvaluator = ctx.getTxnEvaluator();
            if (transactionEvaluator == null) {
                throw new TxBuildException("Transaction evaluator is not set. Transaction evaluator is required to calculate script cost");
            }
            try {
                Result evaluationResult = transactionEvaluator.evaluateTx(transaction.serialize());
                if (!evaluationResult.isSuccessful()) {
                    throw new TxBuildException("Failed to compute script cost : " + evaluationResult.getResponse());
                }
                List evaluationResults = (List)evaluationResult.getValue();
                block2: for (Redeemer redeemer : transaction.getWitnessSet().getRedeemers()) {
                    for (EvaluationResult evalRes : evaluationResults) {
                        if (redeemer.getIndex().intValue() != evalRes.getIndex() || redeemer.getTag() != evalRes.getRedeemerTag()) continue;
                        redeemer.getExUnits().setMem(evalRes.getExUnits().getMem());
                        redeemer.getExUnits().setSteps(evalRes.getExUnits().getSteps());
                        continue block2;
                    }
                }
            }
            catch (ApiException | CborSerializationException e) {
                throw new TxBuildException("Failed to compute script cost", (Exception)e);
            }
        };
    }
}

