/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.api.util.UtxoUtil;
import com.bloxbean.cardano.client.config.Configuration;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.TxInputBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.MinAdaCheckers;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputBuilders {
    private static final Logger log = LoggerFactory.getLogger(InputBuilders.class);

    public static TxInputBuilder createFromSender(String sender, String changeAddress) {
        Objects.requireNonNull(sender, "Sender address cannot be null");
        Objects.requireNonNull(changeAddress, "Change address cannot be null");
        return (context, outputs) -> {
            Optional<Value> burnValue;
            if (!(outputs != null && outputs.size() != 0 || context.getMintMultiAssets() != null && context.getMintMultiAssets().size() != 0)) {
                throw new TxBuildException("No output found. TxInputBuilder transformer should be called after OutputTransformer");
            }
            Value value = Value.builder().coin(BigInteger.ZERO).multiAssets(new ArrayList()).build();
            value = outputs.stream().map(output -> output.getValue()).reduce(value, (value1, value2) -> value1.add(value2));
            List<MultiAsset> mintMultiAssets = context.getMintMultiAssets();
            Optional<Value> mintValue = InputBuilders.findMintValueFromMultiAssets(mintMultiAssets);
            if (mintValue.isPresent()) {
                value = value.subtract(mintValue.get());
            }
            if ((burnValue = InputBuilders.findBurnValueFromMultiAssets(mintMultiAssets)).isPresent()) {
                value = value.add(burnValue.get());
            }
            Set<Utxo> utxoSet = InputBuilders.getUtxosForValue(context, sender, value, Collections.EMPTY_SET);
            List<TransactionInput> _inputs = utxoSet.stream().map(utxo -> new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex())).collect(Collectors.toList());
            if (utxoSet != null && !utxoSet.isEmpty()) {
                TransactionOutput changeOutput = InputBuilders.getChangeOutput(outputs, changeAddress, context.isMergeOutputs());
                outputs.remove(changeOutput);
                utxoSet.stream().forEach(utxo -> {
                    UtxoUtil.copyUtxoValuesToOutput((TransactionOutput)changeOutput, (Utxo)utxo);
                    context.addUtxo((Utxo)utxo);
                });
                Value changedValue = changeOutput.getValue().subtract(value);
                changeOutput.setValue(changedValue);
                BigInteger additionalLovelace = (BigInteger)MinAdaCheckers.minAdaChecker().apply(context, changeOutput);
                if (additionalLovelace.compareTo(BigInteger.ZERO) == 1) {
                    Value additionalValue = Value.builder().coin(additionalLovelace).build();
                    Set<Utxo> additionalUtxos = InputBuilders.getUtxosForValue(context, sender, additionalValue, utxoSet);
                    List additionalInputs = additionalUtxos.stream().map(utxo -> new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex())).collect(Collectors.toList());
                    additionalUtxos.stream().forEach(utxo -> {
                        UtxoUtil.copyUtxoValuesToOutput((TransactionOutput)changeOutput, (Utxo)utxo);
                        context.addUtxo((Utxo)utxo);
                    });
                    _inputs.addAll(additionalInputs);
                }
                return new TxInputBuilder.Result(_inputs, List.of(changeOutput));
            }
            log.warn("Empty input. In normal case, this should not happen.");
            return new TxInputBuilder.Result(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
        };
    }

    private static Optional<Value> findMintValueFromMultiAssets(List<MultiAsset> multiAssets) {
        if (multiAssets == null || multiAssets.isEmpty()) {
            return Optional.empty();
        }
        List mintMultiAssets = multiAssets.stream().map(multiAsset -> {
            List assets = multiAsset.getAssets().stream().filter(asset -> asset.getValue().compareTo(BigInteger.ZERO) > 0).collect(Collectors.toList());
            if (assets != null && !assets.isEmpty()) {
                return new MultiAsset(multiAsset.getPolicyId(), assets);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (mintMultiAssets != null && !mintMultiAssets.isEmpty()) {
            return Optional.of(new Value(BigInteger.ZERO, mintMultiAssets));
        }
        return Optional.empty();
    }

    private static Optional<Value> findBurnValueFromMultiAssets(List<MultiAsset> mintMultiAssets) {
        if (mintMultiAssets == null || mintMultiAssets.isEmpty()) {
            return Optional.empty();
        }
        List burnMultiAssets = mintMultiAssets.stream().map(multiAsset -> {
            List assets = multiAsset.getAssets().stream().filter(asset -> asset.getValue().compareTo(BigInteger.ZERO) < 0).map(asset -> new Asset(asset.getName(), asset.getValue().negate())).collect(Collectors.toList());
            if (assets != null && !assets.isEmpty()) {
                return new MultiAsset(multiAsset.getPolicyId(), assets);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (burnMultiAssets != null && !burnMultiAssets.isEmpty()) {
            return Optional.of(new Value(BigInteger.ZERO, burnMultiAssets));
        }
        return Optional.empty();
    }

    private static Set<Utxo> getUtxosForValue(TxBuilderContext context, String sender, Value value, Set<Utxo> excludeUtxos) {
        List lovelaceUtxos;
        HashSet<Utxo> utxoSet = new HashSet<Utxo>();
        try {
            lovelaceUtxos = value.getCoin() != null && !value.getCoin().equals(BigInteger.ZERO) ? context.getUtxoSelectionStrategy().selectUtxos(sender, "lovelace", value.getCoin(), excludeUtxos) : Collections.EMPTY_LIST;
        }
        catch (ApiException apiException) {
            throw new ApiRuntimeException((Exception)((Object)apiException));
        }
        List multiAssetUtoxs = value.getMultiAssets().stream().flatMap(multiAsset -> multiAsset.getAssets().stream().filter(asset -> !asset.getValue().equals(BigInteger.ZERO)).map(asset -> new Tuple((Object)multiAsset.getPolicyId(), asset))).map(tuple -> {
            String unit = AssetUtil.getUnit((String)((String)tuple._1), (Asset)((Asset)tuple._2));
            try {
                List utxoList = context.getUtxoSelectionStrategy().selectUtxos(sender, unit, ((Asset)tuple._2).getValue(), excludeUtxos);
                if (utxoList != null && utxoList.size() != 0) {
                    return utxoList;
                }
                throw new ApiRuntimeException(String.format("No utxo found at address=%s, unit= %s, value=%s", sender, unit, ((Asset)tuple._2).getValue()));
            }
            catch (ApiException apiException) {
                throw new ApiRuntimeException("Error fetching utxos for qty: " + tuple._2 + ", and asset: " + tuple._2, (Exception)((Object)apiException));
            }
        }).flatMap(list -> list.stream()).collect(Collectors.toList());
        utxoSet.addAll(lovelaceUtxos);
        utxoSet.addAll(multiAssetUtoxs);
        return utxoSet;
    }

    public static TxInputBuilder createFromUtxos(List<Utxo> utxos, String changeAddress) {
        return InputBuilders.createFromUtxos(utxos, changeAddress, null);
    }

    public static TxInputBuilder createFromUtxos(List<Utxo> utxos, String changeAddress, Object datum) {
        if (datum == null) {
            return InputBuilders.createFromUtxos(utxos, changeAddress, null);
        }
        String datumHash = Configuration.INSTANCE.getPlutusObjectConverter().toPlutusData(datum).getDatumHash();
        return InputBuilders.createFromUtxos(utxos, changeAddress, datumHash);
    }

    public static TxInputBuilder createFromUtxos(List<Utxo> utxos, String changeAddress, String datumHash) {
        return InputBuilders.createFromUtxos(() -> utxos, changeAddress, datumHash);
    }

    public static TxInputBuilder createFromUtxos(Supplier<List<Utxo>> supplier, String changeAddress, String datumHash) {
        Objects.requireNonNull(changeAddress, "Change address cannot be null");
        return (context, outputs) -> {
            Optional<Value> burnValue;
            Value value = Value.builder().coin(BigInteger.ZERO).multiAssets(new ArrayList()).build();
            value = outputs.stream().map(TransactionOutput::getValue).reduce(value, Value::add);
            List<MultiAsset> mintMultiAssets = context.getMintMultiAssets();
            Optional<Value> mintValue = InputBuilders.findMintValueFromMultiAssets(mintMultiAssets);
            if (mintValue.isPresent()) {
                value = value.subtract(mintValue.get());
            }
            if ((burnValue = InputBuilders.findBurnValueFromMultiAssets(mintMultiAssets)).isPresent()) {
                value = value.add(burnValue.get());
            }
            List utxos = (List)supplier.get();
            List<TransactionInput> _inputs = utxos.stream().map(utxo -> new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex())).collect(Collectors.toList());
            ArrayList<TransactionOutput> changeOutputs = new ArrayList<TransactionOutput>();
            if (changeAddress != null && !changeAddress.isEmpty()) {
                TransactionOutput changeOutput = InputBuilders.getChangeOutput(outputs, changeAddress, context.isMergeOutputs());
                outputs.remove(changeOutput);
                utxos.forEach(utxo -> {
                    UtxoUtil.copyUtxoValuesToOutput((TransactionOutput)changeOutput, (Utxo)utxo);
                    context.addUtxo((Utxo)utxo);
                });
                Value changedValue = changeOutput.getValue().subtract(value);
                changeOutput.setValue(changedValue);
                if (datumHash != null && !datumHash.isEmpty()) {
                    changeOutput.setDatumHash(HexUtil.decodeHexString((String)datumHash));
                }
                if (!changeOutput.getValue().getCoin().equals(BigInteger.ZERO) || changeOutput.getValue().getMultiAssets() != null && !changeOutput.getValue().getMultiAssets().isEmpty()) {
                    changeOutputs.add(changeOutput);
                }
            }
            return new TxInputBuilder.Result(_inputs, changeOutputs);
        };
    }

    @Deprecated
    public static TxInputBuilder createFromUtxos(List<Utxo> utxos) {
        return (context, outputs) -> {
            ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
            utxos.forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                inputs.add(input);
                context.addUtxo((Utxo)utxo);
            });
            return new TxInputBuilder.Result(inputs, Collections.EMPTY_LIST);
        };
    }

    @Deprecated
    public static TxInputBuilder createFromUtxos(Supplier<List<Utxo>> supplier) {
        return (context, outputs) -> {
            ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
            ((List)supplier.get()).forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                inputs.add(input);
                context.addUtxo((Utxo)utxo);
            });
            return new TxInputBuilder.Result(inputs, Collections.EMPTY_LIST);
        };
    }

    public static TxBuilder referenceInputsFromUtxos(Supplier<List<Utxo>> supplier) {
        return (context, transaction) -> InputBuilders.referenceInputsFromUtxos((List)supplier.get()).apply(context, transaction);
    }

    public static TxBuilder referenceInputsFromUtxos(List<Utxo> utxos) {
        return (context, transaction) -> {
            if (utxos == null || utxos.isEmpty()) {
                return;
            }
            ArrayList referenceInputs = new ArrayList();
            utxos.forEach(utxo -> {
                TransactionInput input = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
                referenceInputs.add(input);
            });
            if (transaction.getBody().getReferenceInputs() == null) {
                transaction.getBody().setReferenceInputs(referenceInputs);
            } else {
                transaction.getBody().getReferenceInputs().addAll(referenceInputs);
            }
        };
    }

    public static TxBuilder referenceInputsFrom(List<TransactionInput> referenceInputs) {
        return (context, transaction) -> {
            if (transaction.getBody().getReferenceInputs() == null) {
                transaction.getBody().setReferenceInputs(referenceInputs);
            } else {
                transaction.getBody().getReferenceInputs().addAll(referenceInputs);
            }
        };
    }

    private static TransactionOutput getChangeOutput(List<TransactionOutput> outputs, String changeAddress, boolean isMergeOutputs) {
        if (changeAddress == null || changeAddress.isEmpty()) {
            throw new TxBuildException("Change address is required");
        }
        if (!isMergeOutputs) {
            return new TransactionOutput(changeAddress, new Value(BigInteger.ZERO, new ArrayList()));
        }
        return outputs.stream().filter(output -> output.getAddress().equals(changeAddress)).findFirst().orElse(new TransactionOutput(changeAddress, new Value(BigInteger.ZERO, new ArrayList())));
    }
}

