/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function;

import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.TxInputBuilder;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@FunctionalInterface
public interface TxOutputBuilder {
    public void accept(TxBuilderContext var1, List<TransactionOutput> var2);

    default public TxOutputBuilder and(TxOutputBuilder after) {
        Objects.requireNonNull(after);
        return (context, outputs) -> {
            this.accept(context, outputs);
            after.accept(context, outputs);
        };
    }

    default public TxBuilder buildInputs(TxInputBuilder after) {
        return this.buildInputs(after, false);
    }

    default public TxBuilder buildInputs(TxInputBuilder after, boolean mergeChangeOutput) {
        return (context, transaction) -> {
            ArrayList inputs = new ArrayList();
            ArrayList<TransactionOutput> outputs = new ArrayList<TransactionOutput>();
            this.accept(context, outputs);
            TxInputBuilder.Result inputBuilderResult = (TxInputBuilder.Result)after.apply(context, outputs);
            if (!inputs.isEmpty()) {
                transaction.getBody().getInputs().addAll(inputs);
            }
            transaction.getBody().getInputs().addAll(inputBuilderResult.inputs);
            if (!outputs.isEmpty()) {
                transaction.getBody().getOutputs().addAll(outputs);
            }
            if (inputBuilderResult.changes != null && !inputBuilderResult.changes.isEmpty()) {
                if (mergeChangeOutput) {
                    inputBuilderResult.changes.forEach(txOutput -> {
                        TransactionOutput txOutputSameAddress = transaction.getBody().getOutputs().stream().filter(transactionOutput -> transactionOutput.getAddress().equals(txOutput.getAddress())).findFirst().orElse(null);
                        if (txOutputSameAddress != null) {
                            txOutputSameAddress.setValue(txOutputSameAddress.getValue().add(txOutput.getValue()));
                        } else {
                            transaction.getBody().getOutputs().add(txOutput);
                        }
                    });
                } else {
                    transaction.getBody().getOutputs().addAll(inputBuilderResult.changes);
                }
            }
            context.clearMintMultiAssets();
        };
    }
}

