/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.api.AddressIterator;
import com.bloxbean.cardano.client.api.common.AddressIterators;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.model.WalletUtxo;
import com.bloxbean.cardano.client.api.util.UtxoUtil;
import com.bloxbean.cardano.client.coinselection.UtxoSelector;
import com.bloxbean.cardano.client.common.CardanoConstants;
import com.bloxbean.cardano.client.crypto.cip1852.DerivationPath;
import com.bloxbean.cardano.client.function.MinAdaChecker;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.FeeCalculators;
import com.bloxbean.cardano.client.function.helper.MinAdaCheckers;
import com.bloxbean.cardano.client.function.helper.RedeemerUtil;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.plutus.spec.RedeemerTag;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeOutputAdjustments {
    private static final Logger log = LoggerFactory.getLogger(ChangeOutputAdjustments.class);
    private static final int MAX_NO_RETRY_TO_ADJUST = 3;
    private static BigInteger changeSelectionBuffer = CardanoConstants.ONE_ADA.multiply(BigInteger.valueOf(2L));
    private static BigInteger DEFAULT_FEE = BigInteger.valueOf(17000L);

    public static TxBuilder adjustChangeOutput(String changeAddress) {
        return ChangeOutputAdjustments.adjustChangeOutput(AddressIterators.of((String)changeAddress), changeAddress, 1);
    }

    public static TxBuilder adjustChangeOutput(String changeAddress, int noOfSigners) {
        return ChangeOutputAdjustments.adjustChangeOutput(AddressIterators.of((String)changeAddress), changeAddress, noOfSigners);
    }

    public static TxBuilder adjustChangeOutput(String senderAddress, String changeAddress, int noOfSigners) {
        return ChangeOutputAdjustments.adjustChangeOutput(AddressIterators.of((String)senderAddress), changeAddress, noOfSigners);
    }

    public static TxBuilder adjustChangeOutput(AddressIterator senderAddressIter, int noOfSigners) {
        String changeAddress = senderAddressIter.getFirst().getAddress();
        return ChangeOutputAdjustments.adjustChangeOutput(senderAddressIter.clone(), changeAddress, noOfSigners);
    }

    public static TxBuilder adjustChangeOutput(AddressIterator senderAddressIter, String changeAddress, int noOfSigners) {
        return (context, transaction) -> {
            int counter = 0;
            while (true) {
                MinAdaChecker minAdaChecker = MinAdaCheckers.minAdaChecker();
                List outputsWithLessAda = transaction.getBody().getOutputs().stream().filter(transactionOutput -> changeAddress.equals(transactionOutput.getAddress())).map(transactionOutput -> new Tuple(transactionOutput, (Object)((BigInteger)minAdaChecker.apply(context, transactionOutput)))).filter(tuple -> ((BigInteger)tuple._2).compareTo(BigInteger.ZERO) == 1).collect(Collectors.toList());
                if (outputsWithLessAda.size() == 0) break;
                if (outputsWithLessAda.size() > 1) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.valueOf(transaction.getBody().getOutputs()));
                    }
                    throw new TxBuildException("Multiple outputs found with same change address with less than min required ada. Can't balance. Please adjust output first.");
                }
                if (counter >= 3) {
                    throw new TxBuildException("Transaction rebalance failed. Max # of retry reached: " + counter);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Trying to adjust the change output. Retry # " + counter);
                }
                try {
                    ChangeOutputAdjustments.adjust(context, transaction, (TransactionOutput)((Tuple)outputsWithLessAda.get((int)0))._1, (BigInteger)((Tuple)outputsWithLessAda.get((int)0))._2, senderAddressIter.clone());
                }
                catch (ApiException apiException) {
                    throw new ApiRuntimeException("Error in api call", (Exception)((Object)apiException));
                }
                FeeCalculators.feeCalculator(changeAddress, noOfSigners).apply(context, transaction);
                ++counter;
            }
        };
    }

    private static void adjust(TxBuilderContext context, Transaction transaction, TransactionOutput outputToAdjust, BigInteger additionalRequiredAmt, AddressIterator senderAddressItr) throws ApiException {
        Address sender;
        String senderAddr;
        Objects.requireNonNull(context);
        Objects.requireNonNull(transaction);
        if (additionalRequiredAmt.compareTo(BigInteger.ZERO) == 0) {
            return;
        }
        List<Tuple> originalRedeemerTxnInputList = null;
        if (transaction.getWitnessSet().getRedeemers() != null && transaction.getWitnessSet().getRedeemers().size() > 0) {
            originalRedeemerTxnInputList = transaction.getWitnessSet().getRedeemers().stream().map(redeemer -> {
                if (redeemer.getTag() == RedeemerTag.Spend) {
                    return new Tuple(redeemer, (Object)RedeemerUtil.getScriptInputFromRedeemer(redeemer, transaction));
                }
                return new Tuple(redeemer, null);
            }).collect(Collectors.toList());
        }
        Set existingUtxos = transaction.getBody().getInputs().stream().map(ti -> Utxo.builder().txHash(ti.getTransactionId()).outputIndex(ti.getIndex()).build()).collect(Collectors.toSet());
        BigInteger totalRequiredWithBuffer = additionalRequiredAmt.add(changeSelectionBuffer);
        ArrayList<Object> newUtxos = new ArrayList<Object>();
        UtxoSelector utxoSelector = context.getUtxoSelector();
        Optional utxoOptional = utxoSelector.findFirst(senderAddr = (sender = senderAddressItr.getFirst()).getAddress(), utxo -> !existingUtxos.contains(utxo) && utxo.getAmount().size() == 1 && ((Amount)utxo.getAmount().get(0)).getQuantity().compareTo(totalRequiredWithBuffer) == 1);
        if (utxoOptional.isPresent()) {
            if (sender.getDerivationPath().isPresent()) {
                WalletUtxo walletUtxo = WalletUtxo.from((Utxo)((Utxo)utxoOptional.get()));
                walletUtxo.setDerivationPath((DerivationPath)sender.getDerivationPath().get());
                newUtxos.add(walletUtxo);
            } else {
                newUtxos.add((Utxo)utxoOptional.get());
            }
        } else {
            List utxosFound = null;
            try {
                utxosFound = context.getUtxoSelectionStrategy().selectUtxos(senderAddressItr.clone(), "lovelace", totalRequiredWithBuffer, existingUtxos);
            }
            catch (ApiException ex) {
                utxosFound = context.getUtxoSelectionStrategy().selectUtxos(senderAddressItr.clone(), "lovelace", additionalRequiredAmt, existingUtxos);
            }
            if (utxosFound != null && utxosFound.size() > 0) {
                newUtxos.addAll(utxosFound);
            }
        }
        newUtxos.forEach(utxo -> {
            transaction.getBody().getInputs().add(new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex()));
            UtxoUtil.copyUtxoValuesToOutput((TransactionOutput)outputToAdjust, (Utxo)utxo);
            context.addUtxo((Utxo)utxo);
        });
        BigInteger existingFee = transaction.getBody().getFee();
        Value changeOutputValue = outputToAdjust.getValue();
        changeOutputValue = changeOutputValue.add(Value.builder().coin(existingFee).build());
        outputToAdjust.setValue(changeOutputValue);
        transaction.getBody().setFee(DEFAULT_FEE);
        if (originalRedeemerTxnInputList != null && originalRedeemerTxnInputList.size() > 0) {
            ArrayList redeemerList = new ArrayList();
            originalRedeemerTxnInputList.forEach(tuple -> {
                Redeemer redeemer = (Redeemer)tuple._1;
                TransactionInput input = (TransactionInput)tuple._2;
                if (redeemer.getTag() == RedeemerTag.Spend) {
                    int index = RedeemerUtil.getScriptInputIndex(input, transaction);
                    if (index == -1) {
                        throw new TxBuildException(String.format("Invalid redeemer index: %s, TransactionInput not found %s", index, input));
                    }
                    redeemer.setIndex(BigInteger.valueOf(index));
                }
                redeemerList.add(redeemer);
            });
            transaction.getWitnessSet().setRedeemers(redeemerList);
        }
    }
}

