/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputMergers {
    private static final Logger log = LoggerFactory.getLogger(OutputMergers.class);

    public static TxBuilder mergeOutputsForAddress(String address) {
        return (context, transaction) -> {
            List addressOutputs = transaction.getBody().getOutputs().stream().filter(output -> output.getAddress().equals(address) && output.getDatumHash() == null && output.getInlineDatum() == null && (output.getScriptRef() == null || output.getScriptRef().length == 0)).collect(Collectors.toList());
            if (addressOutputs == null || addressOutputs.size() == 0 || addressOutputs.size() == 1) {
                return;
            }
            Optional<Value> totalValue = addressOutputs.stream().map(output -> output.getValue()).reduce((value1, value2) -> value1.add(value2));
            TransactionOutput newOutput = new TransactionOutput(address, totalValue.get());
            transaction.getBody().getOutputs().removeAll(addressOutputs);
            transaction.getBody().getOutputs().add(newOutput);
        };
    }
}

