/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.api.AddressIterator;
import com.bloxbean.cardano.client.api.TransactionEvaluator;
import com.bloxbean.cardano.client.api.common.AddressIterators;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.BalanceTxBuilders;
import com.bloxbean.cardano.client.function.helper.ScriptCostEvaluators;
import com.bloxbean.cardano.client.transaction.spec.Value;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptBalanceTxProviders {
    private static final Logger log = LoggerFactory.getLogger(ScriptBalanceTxProviders.class);

    public static TxBuilder balanceTx(String feePayer, int additionalSigners, boolean containsScript) {
        return ScriptBalanceTxProviders.balanceTx(AddressIterators.of((String)feePayer), additionalSigners, containsScript);
    }

    public static TxBuilder balanceTx(AddressIterator feePayerAddrIter, int additionalSigners, boolean containsScript) {
        return (ctx, transaction) -> {
            String feePayerAddr = feePayerAddrIter.getFirst().getAddress();
            int inputSize = transaction.getBody().getInputs().size();
            BalanceTxBuilders.balanceTxWithAdditionalSigners(feePayerAddrIter.clone(), additionalSigners).apply(ctx, transaction);
            int newInputSize = transaction.getBody().getInputs().size();
            if (!containsScript || newInputSize == inputSize) {
                return;
            }
            TransactionEvaluator transactionEvaluator = ctx.getTxnEvaluator();
            if (transactionEvaluator == null) {
                throw new TxBuildException("Transaction evaluator is not set. Transaction evaluator is required to calculate script cost");
            }
            BigInteger fee = transaction.getBody().getFee();
            transaction.getBody().setFee(BigInteger.valueOf(170000L));
            transaction.getBody().getOutputs().stream().filter(output -> feePayerAddr.equals(output.getAddress())).max((to1, to2) -> to1.getValue().getCoin().compareTo(to2.getValue().getCoin())).ifPresent(transactionOutput -> transactionOutput.setValue(transactionOutput.getValue().add(Value.builder().coin(fee).build())));
            Value newCollateralReturnValue = transaction.getBody().getCollateralReturn().getValue().add(Value.builder().coin(transaction.getBody().getTotalCollateral()).build());
            transaction.getBody().getCollateralReturn().setValue(newCollateralReturnValue);
            transaction.getBody().setTotalCollateral(BigInteger.valueOf(1000000L));
            ScriptCostEvaluators.evaluateScriptCost().apply(ctx, transaction);
            BalanceTxBuilders.balanceTxWithAdditionalSigners(feePayerAddrIter, additionalSigners).apply(ctx, transaction);
        };
    }
}

