/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import co.nstant.in.cbor.CborException;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.plutus.spec.CostMdls;
import com.bloxbean.cardano.client.plutus.spec.CostModel;
import com.bloxbean.cardano.client.plutus.spec.Language;
import com.bloxbean.cardano.client.plutus.util.ScriptDataHashGenerator;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.util.CostModelUtil;
import java.util.List;
import java.util.Optional;

public class ScriptDataHashCalculator {
    public static TxBuilder calculateScriptDataHash() {
        return (context, txn) -> ScriptDataHashCalculator.calculateScriptDataHash(context, txn);
    }

    public static void calculateScriptDataHash(TxBuilderContext ctx, Transaction transaction) {
        CostMdls costMdls;
        boolean containsPlutusScript = false;
        if (transaction.getWitnessSet().getPlutusV1Scripts() != null && transaction.getWitnessSet().getPlutusV1Scripts().size() > 0 || transaction.getWitnessSet().getPlutusV2Scripts() != null && transaction.getWitnessSet().getPlutusV2Scripts().size() > 0 || transaction.getWitnessSet().getPlutusV3Scripts() != null && transaction.getWitnessSet().getPlutusV3Scripts().size() > 0 || transaction.getWitnessSet().getRedeemers() != null && transaction.getWitnessSet().getRedeemers().size() > 0) {
            containsPlutusScript = true;
        }
        if ((costMdls = ctx.getCostMdls()) == null) {
            Object costModel;
            costMdls = new CostMdls();
            if (transaction.getWitnessSet().getPlutusV1Scripts() != null && transaction.getWitnessSet().getPlutusV1Scripts().size() > 0) {
                costModel = CostModelUtil.getCostModelFromProtocolParams((ProtocolParams)ctx.getProtocolParams(), (Language)Language.PLUTUS_V1);
                costMdls.add(((Optional)costModel).orElse(CostModelUtil.PlutusV1CostModel));
            }
            if (transaction.getWitnessSet().getPlutusV2Scripts() != null && transaction.getWitnessSet().getPlutusV2Scripts().size() > 0) {
                costModel = CostModelUtil.getCostModelFromProtocolParams((ProtocolParams)ctx.getProtocolParams(), (Language)Language.PLUTUS_V2);
                costMdls.add(((Optional)costModel).orElse(CostModelUtil.PlutusV2CostModel));
            }
            if (transaction.getWitnessSet().getPlutusV3Scripts() != null && transaction.getWitnessSet().getPlutusV3Scripts().size() > 0) {
                costModel = CostModelUtil.getCostModelFromProtocolParams((ProtocolParams)ctx.getProtocolParams(), (Language)Language.PLUTUS_V3);
                costMdls.add(((Optional)costModel).orElse(CostModelUtil.PlutusV3CostModel));
            }
            if (!ctx.getRefScriptLanguages().isEmpty()) {
                for (Language language : ctx.getRefScriptLanguages()) {
                    Optional costModel2 = CostModelUtil.getCostModelFromProtocolParams((ProtocolParams)ctx.getProtocolParams(), (Language)language);
                    costMdls.add((CostModel)costModel2.orElseThrow(() -> new IllegalArgumentException("Cost model not found for language : " + String.valueOf(language))));
                }
            }
        }
        if (containsPlutusScript) {
            byte[] scriptDataHash;
            try {
                scriptDataHash = ScriptDataHashGenerator.generate((Era)ctx.getSerializationEra(), (List)transaction.getWitnessSet().getRedeemers(), (List)transaction.getWitnessSet().getPlutusDataList(), (CostMdls)costMdls);
            }
            catch (CborException | CborSerializationException e) {
                throw new CborRuntimeException((Exception)e);
            }
            transaction.getBody().setScriptDataHash(scriptDataHash);
        }
    }
}

