/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.function.helper;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.model.WalletUtxo;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.function.TxSigner;
import com.bloxbean.cardano.client.transaction.TransactionSigner;
import com.bloxbean.cardano.client.transaction.spec.Policy;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.hdwallet.Wallet;
import java.util.Set;
import java.util.stream.Collectors;

public class SignerProviders {
    public static TxSigner signerFrom(Account ... signers) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.sign(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner signerFrom(Wallet wallet) {
        return (context, transaction) -> {
            Set utxos = context.getAllUtxos().stream().filter(utxo -> utxo instanceof WalletUtxo).map(utxo -> (WalletUtxo)utxo).collect(Collectors.toSet());
            return wallet.sign(transaction, utxos);
        };
    }

    public static TxSigner signerFrom(SecretKey ... secretKeys) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (SecretKey sk : secretKeys) {
                outputTxn = TransactionSigner.INSTANCE.sign(outputTxn, sk);
            }
            return outputTxn;
        };
    }

    public static TxSigner signerFrom(Policy ... policies) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (Policy policy : policies) {
                for (SecretKey sk : policy.getPolicyKeys()) {
                    outputTxn = TransactionSigner.INSTANCE.sign(outputTxn, sk);
                }
            }
            return outputTxn;
        };
    }

    public static TxSigner signerFrom(HdKeyPair ... hdKeyPairs) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (HdKeyPair hdKeyPair : hdKeyPairs) {
                outputTxn = TransactionSigner.INSTANCE.sign(outputTxn, hdKeyPair);
            }
            return outputTxn;
        };
    }

    public static TxSigner stakeKeySignerFrom(Account ... signers) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithStakeKey(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner drepKeySignerFrom(Account ... signers) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithDRepKey(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner stakeKeySignerFrom(Wallet ... wallets) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (Wallet wallet : wallets) {
                outputTxn = wallet.signWithStakeKey(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner committeeColdKeySignerFrom(Account ... signers) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithCommitteeColdKey(outputTxn);
            }
            return outputTxn;
        };
    }

    public static TxSigner committeeHotKeySignerFrom(Account ... signers) {
        return (context, transaction) -> {
            Transaction outputTxn = transaction;
            for (Account signer : signers) {
                outputTxn = signer.signWithCommitteeHotKey(outputTxn);
            }
            return outputTxn;
        };
    }
}

