/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.governance;

import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.client.crypto.VerificationKey;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.transaction.spec.governance.DRepType;
import com.bloxbean.cardano.client.util.HexUtil;

public class DRepId {
    public static final String DREP_ID_PREFIX = "drep";
    public static final String DREP_ID_SCRIPT_PREFIX = "drep_script";

    public static String fromVerificationKey(VerificationKey verificationKey) {
        String keyHash = KeyGenUtil.getKeyHash((VerificationKey)verificationKey);
        String drepId = Bech32.encode((byte[])HexUtil.decodeHexString((String)keyHash), (String)DREP_ID_PREFIX);
        return drepId;
    }

    public static String fromVerificationKeyBytes(byte[] bytes) {
        String keyHash = KeyGenUtil.getKeyHash((byte[])bytes);
        String drepId = Bech32.encode((byte[])HexUtil.decodeHexString((String)keyHash), (String)DREP_ID_PREFIX);
        return drepId;
    }

    public static String fromKeyHash(String keyHash) {
        String drepId = Bech32.encode((byte[])HexUtil.decodeHexString((String)keyHash), (String)DREP_ID_PREFIX);
        return drepId;
    }

    public static String fromScriptHash(String scriptHash) {
        String drepId = Bech32.encode((byte[])HexUtil.decodeHexString((String)scriptHash), (String)DREP_ID_SCRIPT_PREFIX);
        return drepId;
    }

    public static DRep toDrep(String drepId, DRepType drepType) {
        byte[] bytes = Bech32.decode((String)drepId).data;
        if (drepType == DRepType.ADDR_KEYHASH) {
            return DRep.addrKeyHash((String)HexUtil.encodeHexString((byte[])bytes));
        }
        if (drepType == DRepType.SCRIPTHASH) {
            return DRep.scriptHash((String)HexUtil.encodeHexString((byte[])bytes));
        }
        throw new IllegalArgumentException("Invalid DrepType");
    }
}

