/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.governance.keys;

import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPrivateKey;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.util.HexUtil;
import lombok.NonNull;

public class CommitteeHotKey {
    private static final String CC_HOT_KEY = "cc_hot_sk";
    private static final String CC_HOT_VK = "cc_hot_vk";
    private static final String CC_HOT_XSK = "cc_hot_xsk";
    private static final String CC_HOT_XVK = "cc_hot_xvk";
    private static final String CC_HOT = "cc_hot";
    private static final String CC_HOT_SCRIPT = "cc_hot_script";
    private byte[] signingKey;
    private byte[] verificationKey;
    private byte[] extendedSigningKey;
    private byte[] extendedVerificationKey;

    private CommitteeHotKey(@NonNull HdKeyPair hdKeyPair) {
        this(hdKeyPair.getPrivateKey(), hdKeyPair.getPublicKey());
        if (hdKeyPair == null) {
            throw new NullPointerException("hdKeyPair is marked non-null but is null");
        }
    }

    private CommitteeHotKey(HdPrivateKey hdPrivateKey, HdPublicKey hdPublicKey) {
        if (hdPrivateKey != null) {
            this.signingKey = hdPrivateKey.getKeyData();
            this.extendedSigningKey = hdPrivateKey.getBytes();
        }
        if (hdPublicKey != null) {
            this.verificationKey = hdPublicKey.getKeyData();
            this.extendedVerificationKey = hdPublicKey.getBytes();
        }
    }

    public static CommitteeHotKey from(HdKeyPair hdKeyPair) {
        return new CommitteeHotKey(hdKeyPair);
    }

    public static CommitteeHotKey from(HdPrivateKey hdPrivateKey) {
        return new CommitteeHotKey(hdPrivateKey, null);
    }

    public static CommitteeHotKey from(HdPublicKey hdPublicKey) {
        return new CommitteeHotKey(null, hdPublicKey);
    }

    public byte[] signingKey() {
        return this.signingKey;
    }

    public String bech32SigningKey() {
        if (this.signingKey == null) {
            return null;
        }
        return CommitteeHotKey.bech32SigningKey(this.signingKey);
    }

    public byte[] verificationKey() {
        return this.verificationKey;
    }

    public String bech32VerificationKey() {
        if (this.verificationKey == null) {
            return null;
        }
        return CommitteeHotKey.bech32VerificationKey(this.verificationKey);
    }

    public byte[] extendedSigningKey() {
        return this.extendedSigningKey;
    }

    public String bech32ExtendedSigningKey() {
        if (this.extendedSigningKey == null) {
            return null;
        }
        return CommitteeHotKey.bech32ExtendedSigningKey(this.extendedSigningKey);
    }

    public byte[] extendedVerificationKey() {
        return this.extendedVerificationKey;
    }

    public String bech32ExtendedVerificationKey() {
        if (this.extendedVerificationKey == null) {
            return null;
        }
        return CommitteeHotKey.bech32ExtendedVerificationKey(this.extendedVerificationKey);
    }

    public byte[] verificationKeyHash() {
        if (this.verificationKey == null) {
            return null;
        }
        return Blake2bUtil.blake2bHash224((byte[])this.verificationKey);
    }

    public String bech32VerificationKeyHash() {
        return CommitteeHotKey.bech32VerificationKeyHash(this.verificationKeyHash());
    }

    public static String bech32ScriptHash(String scriptHash) {
        return CommitteeHotKey.bech32ScriptHash(HexUtil.decodeHexString((String)scriptHash));
    }

    public static String bech32ScriptHash(byte[] scriptHash) {
        return Bech32.encode((byte[])scriptHash, (String)CC_HOT_SCRIPT);
    }

    public static String bech32VerificationKeyHash(String verificationKeyHash) {
        return CommitteeHotKey.bech32VerificationKeyHash(HexUtil.decodeHexString((String)verificationKeyHash));
    }

    public static String bech32VerificationKeyHash(byte[] verificationKeyHash) {
        return Bech32.encode((byte[])verificationKeyHash, (String)CC_HOT);
    }

    public static String bech32SigningKey(byte[] signingKey) {
        return Bech32.encode((byte[])signingKey, (String)CC_HOT_KEY);
    }

    public static String bech32VerificationKey(byte[] verificationKey) {
        return Bech32.encode((byte[])verificationKey, (String)CC_HOT_VK);
    }

    public static String bech32ExtendedSigningKey(byte[] extendedSigningKey) {
        return Bech32.encode((byte[])extendedSigningKey, (String)CC_HOT_XSK);
    }

    public static String bech32ExtendedVerificationKey(byte[] extendedVerificationKey) {
        return Bech32.encode((byte[])extendedVerificationKey, (String)CC_HOT_XVK);
    }
}

