/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.governance.keys;

import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPrivateKey;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.governance.DRepId;
import lombok.NonNull;

public class DRepKey {
    public static final String DREP_SK = "drep_sk";
    private static final String DREP_VK = "drep_vk";
    private static final String DREP_XSK = "drep_xsk";
    private static final String DREP_XVK = "drep_xvk";
    private byte[] signingKey;
    private byte[] verificationKey;
    private byte[] extendedSigningKey;
    private byte[] extendedVerificationKey;

    private DRepKey(@NonNull HdKeyPair hdKeyPair) {
        this(hdKeyPair.getPrivateKey(), hdKeyPair.getPublicKey());
        if (hdKeyPair == null) {
            throw new NullPointerException("hdKeyPair is marked non-null but is null");
        }
    }

    private DRepKey(HdPrivateKey hdPrivateKey, HdPublicKey hdPublicKey) {
        if (hdPrivateKey != null) {
            this.signingKey = hdPrivateKey.getKeyData();
            this.extendedSigningKey = hdPrivateKey.getBytes();
        }
        if (hdPublicKey != null) {
            this.verificationKey = hdPublicKey.getKeyData();
            this.extendedVerificationKey = hdPublicKey.getBytes();
        }
    }

    public static DRepKey from(HdKeyPair hdKeyPair) {
        return new DRepKey(hdKeyPair);
    }

    public static DRepKey from(HdPrivateKey hdPrivateKey) {
        return new DRepKey(hdPrivateKey, null);
    }

    public static DRepKey from(HdPublicKey hdPublicKey) {
        return new DRepKey(null, hdPublicKey);
    }

    public byte[] signingKey() {
        return this.signingKey;
    }

    public String bech32SigningKey() {
        if (this.signingKey == null) {
            return null;
        }
        return DRepKey.bech32SigningKey(this.signingKey);
    }

    public byte[] verificationKey() {
        return this.verificationKey;
    }

    public String bech32VerificationKey() {
        if (this.verificationKey == null) {
            return null;
        }
        return DRepKey.bech32VerificationKey(this.verificationKey);
    }

    public byte[] extendedSigningKey() {
        return this.extendedSigningKey;
    }

    public String bech32ExtendedSigningKey() {
        if (this.extendedSigningKey == null) {
            return null;
        }
        return DRepKey.bech32ExtendedSigningKey(this.extendedSigningKey);
    }

    public byte[] extendedVerificationKey() {
        return this.extendedVerificationKey;
    }

    public String bech32ExtendedVerificationKey() {
        if (this.extendedVerificationKey == null) {
            return null;
        }
        return DRepKey.bech32ExtendedVerificationKey(this.extendedVerificationKey);
    }

    public byte[] verificationKeyHash() {
        if (this.verificationKey == null) {
            return null;
        }
        return Blake2bUtil.blake2bHash224((byte[])this.verificationKey);
    }

    public String dRepId() {
        if (this.verificationKey == null) {
            return null;
        }
        return DRepKey.drepId(this.verificationKeyHash());
    }

    public static String dRepScriptId(String scriptHash) {
        return DRepId.fromScriptHash(scriptHash);
    }

    public static String dRepScriptId(byte[] scriptHash) {
        return DRepId.fromScriptHash(scriptHash);
    }

    public static String drepId(byte[] keyHash) {
        return DRepId.fromKeyHash(keyHash);
    }

    public static String bech32SigningKey(byte[] signingKey) {
        return Bech32.encode((byte[])signingKey, (String)DREP_SK);
    }

    public static String bech32VerificationKey(byte[] verificationKey) {
        return Bech32.encode((byte[])verificationKey, (String)DREP_VK);
    }

    public static String bech32ExtendedSigningKey(byte[] extendedSigningKey) {
        return Bech32.encode((byte[])extendedSigningKey, (String)DREP_XSK);
    }

    public static String bech32ExtendedVerificationKey(byte[] extendedVerificationKey) {
        return Bech32.encode((byte[])extendedVerificationKey, (String)DREP_XVK);
    }
}

