/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.governance.keys;

import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPrivateKey;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.governance.GovId;
import com.bloxbean.cardano.client.util.HexUtil;
import lombok.NonNull;

public class CommitteeColdKey {
    private static final String CC_COLD_KEY = "cc_cold_sk";
    private static final String CC_COLD_VK = "cc_cold_vk";
    private static final String CC_COLD_XSK = "cc_cold_xsk";
    private static final String CC_COLD_XVK = "cc_cold_xvk";
    private static final String CC_COLD_VKH = "cc_cold_vkh";
    private static final String CC_COLD_SCRIPT = "cc_cold_script";
    private byte[] signingKey;
    private byte[] verificationKey;
    private byte[] extendedSigningKey;
    private byte[] extendedVerificationKey;

    private CommitteeColdKey(@NonNull HdKeyPair hdKeyPair) {
        this(hdKeyPair.getPrivateKey(), hdKeyPair.getPublicKey());
        if (hdKeyPair == null) {
            throw new NullPointerException("hdKeyPair is marked non-null but is null");
        }
    }

    private CommitteeColdKey(HdPrivateKey hdPrivateKey, HdPublicKey hdPublicKey) {
        if (hdPrivateKey != null) {
            this.signingKey = hdPrivateKey.getKeyData();
            this.extendedSigningKey = hdPrivateKey.getBytes();
        }
        if (hdPublicKey != null) {
            this.verificationKey = hdPublicKey.getKeyData();
            this.extendedVerificationKey = hdPublicKey.getBytes();
        }
    }

    public static CommitteeColdKey from(HdKeyPair hdKeyPair) {
        return new CommitteeColdKey(hdKeyPair);
    }

    public static CommitteeColdKey from(HdPrivateKey hdPrivateKey) {
        return new CommitteeColdKey(hdPrivateKey, null);
    }

    public static CommitteeColdKey from(HdPublicKey hdPublicKey) {
        return new CommitteeColdKey(null, hdPublicKey);
    }

    public byte[] signingKey() {
        return this.signingKey;
    }

    public String bech32SigningKey() {
        if (this.signingKey == null) {
            return null;
        }
        return CommitteeColdKey.bech32SigningKey(this.signingKey);
    }

    public byte[] verificationKey() {
        return this.verificationKey;
    }

    public String bech32VerificationKey() {
        if (this.verificationKey == null) {
            return null;
        }
        return CommitteeColdKey.bech32VerificationKey(this.verificationKey);
    }

    public byte[] extendedSigningKey() {
        return this.extendedSigningKey;
    }

    public String bech32ExtendedSigningKey() {
        if (this.extendedSigningKey == null) {
            return null;
        }
        return CommitteeColdKey.bech32ExtendedSigningKey(this.extendedSigningKey);
    }

    public byte[] extendedVerificationKey() {
        return this.extendedVerificationKey;
    }

    public String bech32ExtendedVerificationKey() {
        if (this.extendedVerificationKey == null) {
            return null;
        }
        return CommitteeColdKey.bech32ExtendedVerificationKey(this.extendedVerificationKey);
    }

    public byte[] verificationKeyHash() {
        if (this.verificationKey == null) {
            return null;
        }
        return Blake2bUtil.blake2bHash224((byte[])this.verificationKey);
    }

    public String bech32VerificationKeyHash() {
        return CommitteeColdKey.bech32VerificationKeyHash(this.verificationKeyHash());
    }

    public String id() {
        return GovId.ccColdFromKeyHash(this.verificationKeyHash());
    }

    public static String scriptId(String scriptHash) {
        return CommitteeColdKey.scriptId(HexUtil.decodeHexString((String)scriptHash));
    }

    public static String scriptId(byte[] scriptHash) {
        return GovId.ccColdFromScriptHash(scriptHash);
    }

    public static String bech32ScriptHash(String scriptHash) {
        return CommitteeColdKey.bech32ScriptHash(HexUtil.decodeHexString((String)scriptHash));
    }

    public static String bech32ScriptHash(byte[] scriptHash) {
        return Bech32.encode((byte[])scriptHash, (String)CC_COLD_SCRIPT);
    }

    public static String bech32VerificationKeyHash(String verificationKeyHash) {
        return CommitteeColdKey.bech32VerificationKeyHash(HexUtil.decodeHexString((String)verificationKeyHash));
    }

    public static String bech32VerificationKeyHash(byte[] verificationKeyHash) {
        return Bech32.encode((byte[])verificationKeyHash, (String)CC_COLD_VKH);
    }

    public static String bech32SigningKey(byte[] signingKey) {
        return Bech32.encode((byte[])signingKey, (String)CC_COLD_KEY);
    }

    public static String bech32VerificationKey(byte[] verificationKey) {
        return Bech32.encode((byte[])verificationKey, (String)CC_COLD_VK);
    }

    public static String bech32ExtendedSigningKey(byte[] extendedSigningKey) {
        return Bech32.encode((byte[])extendedSigningKey, (String)CC_COLD_XSK);
    }

    public static String bech32ExtendedVerificationKey(byte[] extendedVerificationKey) {
        return Bech32.encode((byte[])extendedVerificationKey, (String)CC_COLD_XVK);
    }
}

