/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.governance.keys;

import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.crypto.VerificationKey;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPrivateKey;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.governance.GovId;
import com.bloxbean.cardano.client.governance.LegacyDRepId;
import com.bloxbean.cardano.client.util.HexUtil;
import lombok.NonNull;

public class DRepKey {
    public static final String DREP_SK = "drep_sk";
    private static final String DREP_VK = "drep_vk";
    private static final String DREP_XSK = "drep_xsk";
    private static final String DREP_XVK = "drep_xvk";
    private static final String DREP_VKH = "drep_vkh";
    private static final String DREP_SCRIPT = "drep_script";
    private byte[] signingKey;
    private byte[] verificationKey;
    private byte[] extendedSigningKey;
    private byte[] extendedVerificationKey;

    private DRepKey(@NonNull HdKeyPair hdKeyPair) {
        this(hdKeyPair.getPrivateKey(), hdKeyPair.getPublicKey());
        if (hdKeyPair == null) {
            throw new NullPointerException("hdKeyPair is marked non-null but is null");
        }
    }

    private DRepKey(HdPrivateKey hdPrivateKey, HdPublicKey hdPublicKey) {
        if (hdPrivateKey != null) {
            this.signingKey = hdPrivateKey.getKeyData();
            this.extendedSigningKey = hdPrivateKey.getBytes();
        }
        if (hdPublicKey != null) {
            this.verificationKey = hdPublicKey.getKeyData();
            this.extendedVerificationKey = hdPublicKey.getBytes();
        }
    }

    public static DRepKey from(HdKeyPair hdKeyPair) {
        return new DRepKey(hdKeyPair);
    }

    public static DRepKey from(HdPrivateKey hdPrivateKey) {
        return new DRepKey(hdPrivateKey, null);
    }

    public static DRepKey from(HdPublicKey hdPublicKey) {
        return new DRepKey(null, hdPublicKey);
    }

    public byte[] signingKey() {
        return this.signingKey;
    }

    public String bech32SigningKey() {
        if (this.signingKey == null) {
            return null;
        }
        return DRepKey.bech32SigningKey(this.signingKey);
    }

    public byte[] verificationKey() {
        return this.verificationKey;
    }

    public String bech32VerificationKey() {
        if (this.verificationKey == null) {
            return null;
        }
        return DRepKey.bech32VerificationKey(this.verificationKey);
    }

    public byte[] extendedSigningKey() {
        return this.extendedSigningKey;
    }

    public String bech32ExtendedSigningKey() {
        if (this.extendedSigningKey == null) {
            return null;
        }
        return DRepKey.bech32ExtendedSigningKey(this.extendedSigningKey);
    }

    public byte[] extendedVerificationKey() {
        return this.extendedVerificationKey;
    }

    public String bech32ExtendedVerificationKey() {
        if (this.extendedVerificationKey == null) {
            return null;
        }
        return DRepKey.bech32ExtendedVerificationKey(this.extendedVerificationKey);
    }

    public byte[] verificationKeyHash() {
        if (this.verificationKey == null) {
            return null;
        }
        return Blake2bUtil.blake2bHash224((byte[])this.verificationKey);
    }

    public String bech32VerificationKeyHash() {
        if (this.verificationKey == null) {
            return null;
        }
        return DRepKey.bech32VerificationKeyHash(this.verificationKeyHash());
    }

    public String dRepId() {
        if (this.verificationKey == null) {
            return null;
        }
        return DRepKey.drepId(this.verificationKeyHash());
    }

    @Deprecated(since="0.6.3")
    public String legacyDRepId() {
        if (this.verificationKey == null) {
            return null;
        }
        return LegacyDRepId.fromKeyHash(this.verificationKeyHash());
    }

    public static String dRepScriptId(String scriptHash) {
        return GovId.drepFromScriptHash(HexUtil.decodeHexString((String)scriptHash));
    }

    public static String dRepScriptId(byte[] scriptHash) {
        return GovId.drepFromScriptHash(scriptHash);
    }

    public static String drepId(byte[] keyHash) {
        return GovId.drepFromKeyHash(keyHash);
    }

    public static String bech32SigningKey(byte[] signingKey) {
        return Bech32.encode((byte[])signingKey, (String)DREP_SK);
    }

    public static String bech32VerificationKey(byte[] verificationKey) {
        return Bech32.encode((byte[])verificationKey, (String)DREP_VK);
    }

    public static String bech32ExtendedSigningKey(byte[] extendedSigningKey) {
        return Bech32.encode((byte[])extendedSigningKey, (String)DREP_XSK);
    }

    public static String bech32ExtendedVerificationKey(byte[] extendedVerificationKey) {
        return Bech32.encode((byte[])extendedVerificationKey, (String)DREP_XVK);
    }

    public static String bech32VerificationKeyHash(byte[] keyHash) {
        return Bech32.encode((byte[])keyHash, (String)DREP_VKH);
    }

    public static String bech32ScriptHash(byte[] scriptHash) {
        return Bech32.encode((byte[])scriptHash, (String)DREP_SCRIPT);
    }

    public static String bech32VerificationKeyHash(VerificationKey verificationKey) {
        byte[] keyHash = Blake2bUtil.blake2bHash224((byte[])verificationKey.getBytes());
        return Bech32.encode((byte[])keyHash, (String)DREP_VKH);
    }
}

