/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.governance;

import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.address.CredentialType;
import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.util.HexUtil;
import lombok.NonNull;

public class GovId {
    private static final byte CC_HOT_KEY_TYPE = 0;
    private static final byte CC_COLD_KEY_TYPE = 16;
    private static final byte DREP_KEY_TYPE = 32;
    private static final byte KEY_HASH_CRED_TYPE = 2;
    private static final byte SCRIPT_HASH_CRED_TYPE = 3;
    private static final String CC_COLD_PREFIX = "cc_cold";
    private static final String CC_HOT_PREFIX = "cc_hot";
    private static final String DREP_PREFIX = "drep";
    private static final String GOV_ACTION_PREFIX = "gov_action";

    private GovId() {
    }

    public static String ccColdFromKeyHash(byte[] keyHash) {
        byte[] idBytes = GovId.getIdentifierBytes((byte)16, (byte)2, keyHash);
        return Bech32.encode((byte[])idBytes, (String)CC_COLD_PREFIX);
    }

    public static String ccColdFromScriptHash(byte[] scriptHash) {
        byte[] idBytes = GovId.getIdentifierBytes((byte)16, (byte)3, scriptHash);
        return Bech32.encode((byte[])idBytes, (String)CC_COLD_PREFIX);
    }

    public static String ccHotFromKeyHash(byte[] keyHash) {
        byte[] idBytes = GovId.getIdentifierBytes((byte)0, (byte)2, keyHash);
        return Bech32.encode((byte[])idBytes, (String)CC_HOT_PREFIX);
    }

    public static String ccHotFromScriptHash(byte[] scriptHash) {
        byte[] idBytes = GovId.getIdentifierBytes((byte)0, (byte)3, scriptHash);
        return Bech32.encode((byte[])idBytes, (String)CC_HOT_PREFIX);
    }

    public static String drepFromKeyHash(byte[] keyHash) {
        byte[] idBytes = GovId.getIdentifierBytes((byte)32, (byte)2, keyHash);
        return Bech32.encode((byte[])idBytes, (String)DREP_PREFIX);
    }

    public static String drepFromScriptHash(byte[] scriptHash) {
        byte[] idBytes = GovId.getIdentifierBytes((byte)32, (byte)3, scriptHash);
        return Bech32.encode((byte[])idBytes, (String)DREP_PREFIX);
    }

    public static CredentialType credType(String bech32GovId) {
        byte[] govIdBytes = Bech32.decode((String)bech32GovId).data;
        byte header = govIdBytes[0];
        int credType = header & 0xF;
        switch (credType) {
            case 2: {
                return CredentialType.Key;
            }
            case 3: {
                return CredentialType.Script;
            }
        }
        throw new IllegalArgumentException("Invalid credential type : " + credType);
    }

    public static CredentialType credTypeFromIdBytes(String govIdBytes) {
        return GovId.credTypeFromIdBytes(HexUtil.decodeHexString((String)govIdBytes));
    }

    public static CredentialType credTypeFromIdBytes(byte[] govIdBytes) {
        byte header = govIdBytes[0];
        int credType = header & 0xF;
        switch (credType) {
            case 2: {
                return CredentialType.Key;
            }
            case 3: {
                return CredentialType.Script;
            }
        }
        throw new IllegalArgumentException("Invalid credential type : " + credType);
    }

    public static String govAction(String txHash, int index) {
        String indexHex = String.format("%02x", index);
        byte[] mergedBytes = HexUtil.decodeHexString((String)(txHash + indexHex));
        return Bech32.encode((byte[])mergedBytes, (String)GOV_ACTION_PREFIX);
    }

    public static DRep toDrep(@NonNull String drepId) {
        if (drepId == null) {
            throw new NullPointerException("drepId is marked non-null but is null");
        }
        if (!drepId.startsWith(DREP_PREFIX)) {
            throw new IllegalArgumentException("Invalid drep id prefix");
        }
        byte[] idBytes = Bech32.decode((String)drepId).data;
        byte[] keyBytes = new byte[idBytes.length - 1];
        if (keyBytes.length != 28) {
            throw new IllegalArgumentException("Key bytes length should be 28, but found " + keyBytes.length);
        }
        System.arraycopy(idBytes, 1, keyBytes, 0, idBytes.length - 1);
        CredentialType credType = GovId.credTypeFromIdBytes(idBytes);
        if (credType == CredentialType.Key) {
            return DRep.addrKeyHash((byte[])keyBytes);
        }
        if (credType == CredentialType.Script) {
            return DRep.scriptHash((byte[])keyBytes);
        }
        throw new IllegalArgumentException("Invalid credential type");
    }

    public static Credential ccHotToCredential(@NonNull String ccHotId) {
        if (ccHotId == null) {
            throw new NullPointerException("ccHotId is marked non-null but is null");
        }
        if (!ccHotId.startsWith(CC_HOT_PREFIX)) {
            throw new IllegalArgumentException("Invalid cc hot id prefix");
        }
        byte[] idBytes = Bech32.decode((String)ccHotId).data;
        byte[] keyBytes = new byte[idBytes.length - 1];
        if (keyBytes.length != 28) {
            throw new IllegalArgumentException("Key bytes length should be 28, but found " + keyBytes.length);
        }
        System.arraycopy(idBytes, 1, keyBytes, 0, idBytes.length - 1);
        CredentialType credType = GovId.credTypeFromIdBytes(idBytes);
        if (credType == CredentialType.Key) {
            return Credential.fromKey((byte[])keyBytes);
        }
        if (credType == CredentialType.Script) {
            return Credential.fromScript((byte[])keyBytes);
        }
        throw new IllegalArgumentException("Invalid credential type");
    }

    public static Credential ccColdToCredential(@NonNull String ccColdId) {
        if (ccColdId == null) {
            throw new NullPointerException("ccColdId is marked non-null but is null");
        }
        if (!ccColdId.startsWith(CC_COLD_PREFIX)) {
            throw new IllegalArgumentException("Invalid cc cold id prefix");
        }
        byte[] idBytes = Bech32.decode((String)ccColdId).data;
        byte[] keyBytes = new byte[idBytes.length - 1];
        if (keyBytes.length != 28) {
            throw new IllegalArgumentException("Key bytes length should be 28, but found " + keyBytes.length);
        }
        System.arraycopy(idBytes, 1, keyBytes, 0, idBytes.length - 1);
        CredentialType credType = GovId.credTypeFromIdBytes(idBytes);
        if (credType == CredentialType.Key) {
            return Credential.fromKey((byte[])keyBytes);
        }
        if (credType == CredentialType.Script) {
            return Credential.fromScript((byte[])keyBytes);
        }
        throw new IllegalArgumentException("Invalid credential type");
    }

    private static byte[] getIdentifierBytes(byte keyType, byte credType, byte[] keyHash) {
        byte header = GovId.getHeader(keyType, credType);
        byte[] idBytes = new byte[1 + keyHash.length];
        idBytes[0] = header;
        System.arraycopy(keyHash, 0, idBytes, 1, keyHash.length);
        return idBytes;
    }

    private static byte getHeader(byte keyType, byte credType) {
        return (byte)(keyType | credType & 0xF);
    }
}

