/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.governance;

import com.bloxbean.cardano.client.crypto.Bech32;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.crypto.VerificationKey;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.transaction.spec.governance.DRepType;
import com.bloxbean.cardano.client.util.HexUtil;

@Deprecated(since="0.6.3")
public class LegacyDRepId {
    public static final String DREP_ID_PREFIX = "drep";
    public static final String DREP_ID_SCRIPT_PREFIX = "drep_script";

    public static String fromVerificationKey(VerificationKey verificationKey) {
        byte[] keyHash = Blake2bUtil.blake2bHash224((byte[])verificationKey.getBytes());
        return Bech32.encode((byte[])keyHash, (String)DREP_ID_PREFIX);
    }

    public static String fromVerificationKeyBytes(byte[] bytes) {
        byte[] keyHash = Blake2bUtil.blake2bHash224((byte[])bytes);
        return Bech32.encode((byte[])keyHash, (String)DREP_ID_PREFIX);
    }

    public static String fromKeyHash(String keyHash) {
        return LegacyDRepId.fromKeyHash(HexUtil.decodeHexString((String)keyHash));
    }

    public static String fromKeyHash(byte[] keyHash) {
        return Bech32.encode((byte[])keyHash, (String)DREP_ID_PREFIX);
    }

    public static String fromScriptHash(String scriptHash) {
        return LegacyDRepId.fromScriptHash(HexUtil.decodeHexString((String)scriptHash));
    }

    public static String fromScriptHash(byte[] scriptHash) {
        return Bech32.encode((byte[])scriptHash, (String)DREP_ID_SCRIPT_PREFIX);
    }

    public static DRep toDrep(String drepId, DRepType drepType) {
        byte[] bytes = Bech32.decode((String)drepId).data;
        if (bytes.length != 28) {
            throw new IllegalArgumentException("DRep key bytes length should be 28, but found " + bytes.length);
        }
        if (drepType == DRepType.ADDR_KEYHASH) {
            return DRep.addrKeyHash((String)HexUtil.encodeHexString((byte[])bytes));
        }
        if (drepType == DRepType.SCRIPTHASH) {
            return DRep.scriptHash((String)HexUtil.encodeHexString((byte[])bytes));
        }
        throw new IllegalArgumentException("Invalid DrepType");
    }
}

