/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.hdwallet;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressProvider;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.crypto.MnemonicUtil;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyGenerator;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.crypto.bip39.MnemonicCode;
import com.bloxbean.cardano.client.crypto.bip39.MnemonicException;
import com.bloxbean.cardano.client.crypto.bip39.Words;
import com.bloxbean.cardano.client.crypto.cip1852.CIP1852;
import com.bloxbean.cardano.client.crypto.cip1852.DerivationPath;
import com.bloxbean.cardano.client.transaction.TransactionSigner;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.hdwallet.WalletException;
import com.bloxbean.cardano.hdwallet.model.WalletUtxo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Wallet {
    private int account = 0;
    private final Network network;
    private final String mnemonic;
    private String stakeAddress;
    private Map<Integer, Account> cache;
    private HdKeyPair rootKeys;
    private HdKeyPair stakeKeys;
    private int[] indexesToScan;
    private int gapLimit = 20;

    public Wallet() {
        this(Networks.mainnet());
    }

    public Wallet(Network network) {
        this(network, Words.TWENTY_FOUR);
    }

    public Wallet(Network network, Words noOfWords) {
        this(network, noOfWords, 0);
    }

    public Wallet(Network network, Words noOfWords, int account) {
        this.network = network;
        this.mnemonic = MnemonicUtil.generateNew((Words)noOfWords);
        this.account = account;
        this.cache = new HashMap<Integer, Account>();
    }

    public Wallet(String mnemonic) {
        this(Networks.mainnet(), mnemonic);
    }

    public Wallet(Network network, String mnemonic) {
        this(network, mnemonic, 0);
    }

    public Wallet(Network network, String mnemonic, int account) {
        this.network = network;
        this.mnemonic = mnemonic;
        this.account = account;
        MnemonicUtil.validateMnemonic((String)this.mnemonic);
        this.cache = new HashMap<Integer, Account>();
    }

    public Address getEntAddress(int index) {
        return this.getEntAddress(this.account, index);
    }

    private Address getEntAddress(int account, int index) {
        return this.getAccount(account, index).getEnterpriseAddress();
    }

    public Address getBaseAddress(int index) {
        return this.getBaseAddress(this.account, index);
    }

    public String getBaseAddressString(int index) {
        return this.getBaseAddress(index).getAddress();
    }

    public Address getBaseAddress(int account, int index) {
        return this.getAccount(account, index).getBaseAddress();
    }

    public Account getAccount(int index) {
        return this.getAccount(this.account, index);
    }

    public Account getAccount(int account, int index) {
        if (account != this.account) {
            DerivationPath derivationPath = DerivationPath.createExternalAddressDerivationPathForAccount((int)account);
            derivationPath.getIndex().setValue(index);
            return new Account(this.network, this.mnemonic, derivationPath);
        }
        if (this.cache.containsKey(index)) {
            return this.cache.get(index);
        }
        Account acc = new Account(this.network, this.mnemonic, index);
        this.cache.put(index, acc);
        return acc;
    }

    public void setAccount(int account) {
        this.account = account;
        this.cache = new HashMap<Integer, Account>();
    }

    @JsonIgnore
    public HdKeyPair getRootKeyPair() {
        if (this.rootKeys == null) {
            HdKeyGenerator hdKeyGenerator = new HdKeyGenerator();
            try {
                byte[] entropy = MnemonicCode.INSTANCE.toEntropy(this.mnemonic);
                this.rootKeys = hdKeyGenerator.getRootKeyPairFromEntropy(entropy);
            }
            catch (MnemonicException.MnemonicChecksumException | MnemonicException.MnemonicLengthException | MnemonicException.MnemonicWordException e) {
                throw new WalletException("Unable to derive root key pair", e);
            }
        }
        return this.rootKeys;
    }

    public Transaction sign(Transaction txToSign, Set<WalletUtxo> utxos) {
        Map accountMap = utxos.stream().map(WalletUtxo::getDerivationPath).filter(Objects::nonNull).map(derivationPath -> this.getAccount(derivationPath.getAccount().getValue(), derivationPath.getIndex().getValue())).collect(Collectors.toMap(Account::baseAddress, Function.identity(), (existing, replacement) -> existing));
        Collection accounts = accountMap.values();
        if (accounts.isEmpty()) {
            throw new WalletException("No signers found!");
        }
        for (Account signerAcc : accounts) {
            txToSign = signerAcc.sign(txToSign);
        }
        return txToSign;
    }

    public String getStakeAddress() {
        if (this.stakeAddress == null || this.stakeAddress.isEmpty()) {
            HdKeyPair stakeKeyPair = this.getStakeKeyPair();
            Address address = AddressProvider.getRewardAddress((HdPublicKey)stakeKeyPair.getPublicKey(), (Network)this.network);
            this.stakeAddress = address.toBech32();
        }
        return this.stakeAddress;
    }

    public Transaction signWithStakeKey(Transaction transaction) {
        return TransactionSigner.INSTANCE.sign(transaction, this.getStakeKeyPair());
    }

    private HdKeyPair getStakeKeyPair() {
        if (this.stakeKeys == null) {
            DerivationPath stakeDerivationPath = DerivationPath.createStakeAddressDerivationPathForAccount((int)this.account);
            this.stakeKeys = new CIP1852().getKeyPairFromMnemonic(this.mnemonic, stakeDerivationPath);
        }
        return this.stakeKeys;
    }

    public int getAccount() {
        return this.account;
    }

    public Network getNetwork() {
        return this.network;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public int[] getIndexesToScan() {
        return this.indexesToScan;
    }

    public void setIndexesToScan(int[] indexesToScan) {
        this.indexesToScan = indexesToScan;
    }

    public int getGapLimit() {
        return this.gapLimit;
    }

    public void setGapLimit(int gapLimit) {
        this.gapLimit = gapLimit;
    }
}

