/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.hdwallet.supplier;

import com.bloxbean.cardano.client.api.common.OrderEnum;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.crypto.cip1852.DerivationPath;
import com.bloxbean.cardano.client.crypto.cip1852.Segment;
import com.bloxbean.cardano.hdwallet.Wallet;
import com.bloxbean.cardano.hdwallet.WalletException;
import com.bloxbean.cardano.hdwallet.model.WalletUtxo;
import com.bloxbean.cardano.hdwallet.supplier.WalletUtxoSupplier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultWalletUtxoSupplier
implements WalletUtxoSupplier {
    private final UtxoService utxoService;
    private Wallet wallet;

    public DefaultWalletUtxoSupplier(UtxoService utxoService, Wallet wallet) {
        this.utxoService = utxoService;
        this.wallet = wallet;
    }

    public List<Utxo> getPage(String address, Integer nrOfItems, Integer page, OrderEnum order) {
        return this.getAll(address);
    }

    public Optional<Utxo> getTxOutput(String txHash, int outputIndex) {
        try {
            Result result = this.utxoService.getTxOutput(txHash, outputIndex);
            return result != null && result.getValue() != null ? Optional.of(WalletUtxo.from((Utxo)result.getValue())) : Optional.empty();
        }
        catch (ApiException e) {
            throw new ApiRuntimeException((Exception)((Object)e));
        }
    }

    public List<Utxo> getAll(String address) {
        this.checkIfWalletIsSet();
        return new ArrayList<Utxo>(this.getAll());
    }

    @Override
    public List<WalletUtxo> getAll() {
        ArrayList<WalletUtxo> utxos = new ArrayList<WalletUtxo>();
        if (this.wallet.getIndexesToScan() == null || this.wallet.getIndexesToScan().length == 0) {
            int index = 0;
            int noUtxoFound = 0;
            while (noUtxoFound < this.wallet.getGapLimit()) {
                List<WalletUtxo> utxoFromIndex = this.getUtxosForAccountAndIndex(this.wallet.getAccount(), index);
                utxos.addAll(utxoFromIndex);
                noUtxoFound = utxoFromIndex.isEmpty() ? noUtxoFound + 1 : 0;
                ++index;
            }
        } else {
            for (int idx : this.wallet.getIndexesToScan()) {
                List<WalletUtxo> utxoFromIndex = this.getUtxosForAccountAndIndex(this.wallet.getAccount(), idx);
                utxos.addAll(utxoFromIndex);
            }
        }
        return utxos;
    }

    @Override
    public List<WalletUtxo> getUtxosForAccountAndIndex(int account, int index) {
        this.checkIfWalletIsSet();
        String address = this.wallet.getBaseAddress(account, index).getAddress();
        ArrayList<WalletUtxo> utxos = new ArrayList<WalletUtxo>();
        int page = 1;
        while (true) {
            Result result = null;
            try {
                result = this.utxoService.getUtxos(address, 100, page, OrderEnum.asc);
            }
            catch (ApiException e) {
                throw new ApiRuntimeException((Exception)((Object)e));
            }
            List utxoPage = result != null && result.getValue() != null ? (List)result.getValue() : Collections.emptyList();
            DerivationPath derivationPath = DerivationPath.createExternalAddressDerivationPathForAccount((int)account);
            derivationPath.setIndex(Segment.builder().value(index).build());
            List utxoList = utxoPage.stream().map(utxo -> {
                WalletUtxo walletUtxo = WalletUtxo.from(utxo);
                walletUtxo.setDerivationPath(derivationPath);
                return walletUtxo;
            }).collect(Collectors.toList());
            utxos.addAll(utxoList);
            if (utxoPage.size() < 100) break;
            ++page;
        }
        return utxos;
    }

    private void checkIfWalletIsSet() {
        if (this.wallet == null) {
            throw new WalletException("Wallet has to be provided!");
        }
    }

    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }
}

