/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.hdwallet;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressProvider;
import com.bloxbean.cardano.client.api.model.WalletUtxo;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.crypto.MnemonicUtil;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyGenerator;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip32.key.HdPublicKey;
import com.bloxbean.cardano.client.crypto.bip39.MnemonicCode;
import com.bloxbean.cardano.client.crypto.bip39.MnemonicException;
import com.bloxbean.cardano.client.crypto.bip39.Words;
import com.bloxbean.cardano.client.crypto.cip1852.CIP1852;
import com.bloxbean.cardano.client.crypto.cip1852.DerivationPath;
import com.bloxbean.cardano.client.transaction.TransactionSigner;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.hdwallet.Wallet;
import com.bloxbean.cardano.hdwallet.WalletException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultWallet
implements Wallet {
    private int accountNo = 0;
    private final Network network;
    @JsonIgnore
    private String mnemonic;
    @JsonIgnore
    private byte[] rootKey;
    @JsonIgnore
    private byte[] accountKey;
    private String stakeAddress;
    private Map<Integer, Account> cache;
    private HdKeyPair rootKeyPair;
    private HdKeyPair stakeKeys;
    private int[] indexesToScan;
    private int gapLimit = 20;

    public DefaultWallet() {
        this(Networks.mainnet());
    }

    public DefaultWallet(Network network) {
        this(network, Words.TWENTY_FOUR);
    }

    public DefaultWallet(Network network, Words noOfWords) {
        this(network, noOfWords, 0);
    }

    public DefaultWallet(Network network, Words noOfWords, int account) {
        this.network = network;
        this.mnemonic = MnemonicUtil.generateNew((Words)noOfWords);
        this.accountNo = account;
        this.cache = new HashMap<Integer, Account>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DefaultWallet(Network network, String mnemonic, byte[] rootKey, byte[] accountKey, int account) {
        if ((mnemonic != null && !mnemonic.isEmpty() ? 1 : 0) + (rootKey != null && rootKey.length > 0 ? 1 : 0) + (accountKey != null && accountKey.length > 0 ? 1 : 0) > 1) {
            throw new WalletException("Only one of mnemonic, rootKey, or accountKey should be set.");
        }
        this.network = network;
        this.cache = new HashMap<Integer, Account>();
        if (mnemonic != null && !mnemonic.isEmpty()) {
            this.mnemonic = mnemonic;
            this.accountNo = account;
            MnemonicUtil.validateMnemonic((String)this.mnemonic);
            return;
        } else if (rootKey != null && rootKey.length > 0) {
            this.accountNo = account;
            if (rootKey.length != 96) throw new WalletException("Invalid length (Root Key): " + rootKey.length);
            this.rootKey = rootKey;
            return;
        } else {
            if (accountKey == null || accountKey.length <= 0) return;
            this.accountNo = account;
            if (accountKey.length != 96) throw new WalletException("Invalid length (Account Private Key): " + accountKey.length);
            this.accountKey = accountKey;
        }
    }

    @Override
    public Address getEntAddress(int index) {
        return this.getEntAddress(this.accountNo, index);
    }

    private Address getEntAddress(int account, int index) {
        return this.getAccount(account, index).getEnterpriseAddress();
    }

    @Override
    public Address getBaseAddress(int index) {
        return this.getBaseAddress(this.accountNo, index);
    }

    @Override
    public String getBaseAddressString(int index) {
        return this.getBaseAddress(index).getAddress();
    }

    @Override
    public Address getBaseAddress(int account, int index) {
        return this.getAccount(account, index).getBaseAddress();
    }

    @Override
    public Account getAccountAtIndex(int index) {
        return this.getAccount(this.accountNo, index);
    }

    @Override
    public Account getAccount(int account, int index) {
        if (account != this.accountNo) {
            return this.deriveAccount(account, index);
        }
        if (this.cache.containsKey(index)) {
            return this.cache.get(index);
        }
        Account acc = this.deriveAccount(account, index);
        if (acc != null) {
            this.cache.put(index, acc);
        }
        return acc;
    }

    private Account deriveAccount(int account, int index) {
        DerivationPath derivationPath = DerivationPath.createExternalAddressDerivationPathForAccount((int)account);
        derivationPath.getIndex().setValue(index);
        if (this.mnemonic != null && !this.mnemonic.isEmpty()) {
            return Account.createFromMnemonic((Network)this.network, (String)this.mnemonic, (DerivationPath)derivationPath);
        }
        if (this.rootKey != null && this.rootKey.length > 0) {
            return Account.createFromRootKey((Network)this.network, (byte[])this.rootKey, (DerivationPath)derivationPath);
        }
        if (this.accountKey != null && this.accountKey.length > 0) {
            return Account.createFromAccountKey((Network)this.network, (byte[])this.accountKey, (DerivationPath)derivationPath);
        }
        throw new WalletException("Can't create Account. At least one of 'mnemonic', 'accountKey', or 'rootKey' must be set.");
    }

    @Override
    public void setAccountNo(int account) {
        this.accountNo = account;
        this.cache = new HashMap<Integer, Account>();
    }

    @Override
    public int getAccountNo() {
        return this.accountNo;
    }

    @Override
    @JsonIgnore
    public Optional<HdKeyPair> getRootKeyPair() {
        if (this.rootKeyPair == null) {
            if (this.mnemonic != null && !this.mnemonic.isEmpty()) {
                HdKeyGenerator hdKeyGenerator = new HdKeyGenerator();
                try {
                    byte[] entropy = MnemonicCode.INSTANCE.toEntropy(this.mnemonic);
                    this.rootKeyPair = hdKeyGenerator.getRootKeyPairFromEntropy(entropy);
                }
                catch (MnemonicException.MnemonicChecksumException | MnemonicException.MnemonicLengthException | MnemonicException.MnemonicWordException e) {
                    throw new WalletException("Unable to derive root key pair", e);
                }
            } else if (this.rootKey != null && this.rootKey.length > 0) {
                HdKeyGenerator hdKeyGenerator = new HdKeyGenerator();
                this.rootKeyPair = hdKeyGenerator.getKeyPairFromSecretKey(this.rootKey, "m");
            }
        }
        return Optional.ofNullable(this.rootKeyPair);
    }

    @Override
    public Optional<byte[]> getRootPvtKey() {
        return this.getRootKeyPair().map(rkp -> rkp.getPrivateKey().getBytes());
    }

    @Override
    public Transaction sign(Transaction txToSign, Set<WalletUtxo> utxos) {
        Map accountMap = utxos.stream().map(WalletUtxo::getDerivationPath).filter(Objects::nonNull).map(derivationPath -> this.getAccount(derivationPath.getAccount().getValue(), derivationPath.getIndex().getValue())).collect(Collectors.toMap(Account::baseAddress, Function.identity(), (existing, replacement) -> existing));
        Collection accounts = accountMap.values();
        if (accounts.isEmpty()) {
            throw new WalletException("No signers found!");
        }
        for (Account signerAcc : accounts) {
            txToSign = signerAcc.sign(txToSign);
        }
        return txToSign;
    }

    @Override
    public String getStakeAddress() {
        if (this.stakeAddress == null || this.stakeAddress.isEmpty()) {
            HdKeyPair stakeKeyPair = this.getStakeKeyPair();
            Address address = AddressProvider.getRewardAddress((HdPublicKey)stakeKeyPair.getPublicKey(), (Network)this.network);
            this.stakeAddress = address.toBech32();
        }
        return this.stakeAddress;
    }

    @Override
    public Transaction signWithStakeKey(Transaction transaction) {
        return TransactionSigner.INSTANCE.sign(transaction, this.getStakeKeyPair());
    }

    private HdKeyPair getStakeKeyPair() {
        if (this.stakeKeys == null) {
            DerivationPath stakeDerivationPath = DerivationPath.createStakeAddressDerivationPathForAccount((int)this.accountNo);
            this.stakeKeys = new CIP1852().getKeyPairFromMnemonic(this.mnemonic, stakeDerivationPath);
        }
        return this.stakeKeys;
    }

    @Override
    public Network getNetwork() {
        return this.network;
    }

    @Override
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public int[] getIndexesToScan() {
        return this.indexesToScan;
    }

    @Override
    public void setIndexesToScan(int[] indexesToScan) {
        this.indexesToScan = indexesToScan;
    }

    @Override
    public int getGapLimit() {
        return this.gapLimit;
    }

    @Override
    public void setGapLimit(int gapLimit) {
        this.gapLimit = gapLimit;
    }
}

