/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.hdwallet;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.api.model.WalletUtxo;
import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.bip39.Words;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.hdwallet.DefaultWallet;
import java.util.Optional;
import java.util.Set;

public interface Wallet {
    public Address getEntAddress(int var1);

    public Address getBaseAddress(int var1);

    public String getBaseAddressString(int var1);

    public Address getBaseAddress(int var1, int var2);

    public String getStakeAddress();

    public Account getAccountAtIndex(int var1);

    public Account getAccount(int var1, int var2);

    public void setAccountNo(int var1);

    public int getAccountNo();

    public Optional<HdKeyPair> getRootKeyPair();

    public Optional<byte[]> getRootPvtKey();

    public String getMnemonic();

    public Transaction sign(Transaction var1, Set<WalletUtxo> var2);

    public Transaction signWithStakeKey(Transaction var1);

    public Network getNetwork();

    public int[] getIndexesToScan();

    public void setIndexesToScan(int[] var1);

    public int getGapLimit();

    public void setGapLimit(int var1);

    public static Wallet create() {
        return new DefaultWallet();
    }

    public static Wallet create(Network network) {
        return new DefaultWallet(network);
    }

    public static Wallet create(Network network, Words noOfWords) {
        return new DefaultWallet(network, noOfWords, 0);
    }

    public static Wallet create(Network network, Words noOfWords, int account) {
        return new DefaultWallet(network, noOfWords, account);
    }

    public static Wallet createFromMnemonic(String mnemonic) {
        return Wallet.createFromMnemonic(Networks.mainnet(), mnemonic, 0);
    }

    public static Wallet createFromMnemonic(Network network, String mnemonic) {
        return Wallet.createFromMnemonic(network, mnemonic, 0);
    }

    public static Wallet createFromMnemonic(Network network, String mnemonic, int account) {
        return new DefaultWallet(network, mnemonic, null, null, account);
    }

    public static Wallet createFromRootKey(Network network, byte[] rootKey) {
        return Wallet.createFromRootKey(network, rootKey, 0);
    }

    public static Wallet createFromRootKey(Network network, byte[] rootKey, int account) {
        return new DefaultWallet(network, null, rootKey, null, account);
    }

    public static Wallet createFromAccountKey(Network network, byte[] accountKey) {
        return new DefaultWallet(network, null, null, accountKey, 0);
    }
}

