/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.hdwallet.util;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.api.AddressIterator;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.hdwallet.Wallet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDWalletAddressIterator
implements AddressIterator {
    private static final Logger log = LoggerFactory.getLogger(HDWalletAddressIterator.class);
    private Wallet wallet;
    private UtxoSupplier utxoSupplier;
    private int index = 0;
    private int gapCount = 0;
    private Iterator<Integer> indexesToScan;

    public HDWalletAddressIterator(Wallet wallet, UtxoSupplier utxoSupplier) {
        this.wallet = wallet;
        this.utxoSupplier = utxoSupplier;
        this.indexesToScan = wallet.getIndexesToScan() != null && wallet.getIndexesToScan().length > 0 ? Arrays.stream(wallet.getIndexesToScan()).iterator() : null;
    }

    public boolean hasNext() {
        if (this.indexesToScan != null) {
            return this.indexesToScan.hasNext();
        }
        return this.gapCount < this.wallet.getGapLimit();
    }

    public Address next() {
        Address address;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.indexesToScan != null) {
            address = this.wallet.getBaseAddress(this.indexesToScan.next());
        } else {
            address = this.wallet.getBaseAddress(this.index);
            if (log.isTraceEnabled()) {
                log.trace("Scanning derivation path: " + String.valueOf(address.getDerivationPath().get()));
            }
            this.gapCount = this.utxoSupplier.isUsedAddress(address) ? 0 : ++this.gapCount;
            ++this.index;
        }
        return address;
    }

    public String toString() {
        if (this.wallet != null) {
            return this.wallet.getBaseAddress(0).toBech32();
        }
        return super.toString();
    }

    public Address getFirst() {
        return this.wallet.getBaseAddress(0);
    }

    public void reset() {
        this.index = 0;
        this.gapCount = 0;
        this.indexesToScan = this.wallet.getIndexesToScan() != null && this.wallet.getIndexesToScan().length > 0 ? Arrays.stream(this.wallet.getIndexesToScan()).iterator() : null;
    }

    public AddressIterator clone() {
        return new HDWalletAddressIterator(this.wallet, this.utxoSupplier);
    }
}

