/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.account;

import com.bloxbean.cardano.client.common.model.Network;
import com.bloxbean.cardano.client.common.model.Networks;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.jna.CardanoJNAUtil;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class Account {
    @JsonIgnore
    private String mnemonic;
    private String baseAddress;
    private String enterpriseAddress;
    private Network network;
    private int index;
    @JsonIgnore
    private String privateKey;
    @JsonIgnore
    private byte[] privateKeyBytes;
    @JsonIgnore
    private byte[] publicKeyBytes;

    public Account() {
        this((Network)Networks.mainnet(), 0);
    }

    public Account(int index) {
        this((Network)Networks.mainnet(), index);
    }

    public Account(Network network) {
        this(network, 0);
    }

    public Account(Network network, int index) {
        this.network = network;
        this.index = index;
        this.generateNew();
    }

    public Account(String mnemonic) {
        this(Networks.mainnet(), mnemonic, 0);
    }

    public Account(String mnemonic, int index) {
        this(Networks.mainnet(), mnemonic, index);
    }

    public Account(Network network, String mnemonic) {
        this(network, mnemonic, 0);
    }

    public Account(Network network, String mnemonic, int index) {
        this.network = network;
        this.mnemonic = mnemonic;
        this.index = index;
        this.getPrivateKey();
        this.baseAddress();
    }

    public String mnemonic() {
        return this.mnemonic;
    }

    public String baseAddress() {
        if (this.baseAddress == null || this.baseAddress.trim().length() == 0) {
            Network.ByReference refNetwork = new Network.ByReference();
            refNetwork.network_id = this.network.network_id;
            refNetwork.protocol_magic = this.network.protocol_magic;
            this.baseAddress = CardanoJNAUtil.getBaseAddressByNetwork(this.mnemonic, this.index, refNetwork);
        }
        return this.baseAddress;
    }

    public String enterpriseAddress() {
        if (this.enterpriseAddress == null || this.enterpriseAddress.trim().length() == 0) {
            Network.ByReference refNetwork = new Network.ByReference();
            refNetwork.network_id = this.network.network_id;
            refNetwork.protocol_magic = this.network.protocol_magic;
            this.enterpriseAddress = CardanoJNAUtil.getEnterpriseAddressByNetwork(this.mnemonic, this.index, refNetwork);
        }
        return this.enterpriseAddress;
    }

    @JsonIgnore
    public String getBech32PrivateKey() {
        return this.privateKey;
    }

    @JsonIgnore
    public byte[] privateKeyBytes() {
        return this.privateKeyBytes;
    }

    @JsonIgnore
    public byte[] publicKeyBytes() {
        return this.publicKeyBytes;
    }

    public String sign(Transaction transaction) throws CborSerializationException {
        String txnHex = transaction.serializeToHex();
        if (txnHex == null || txnHex.length() == 0) {
            throw new CborSerializationException("Transaction could not be serialized");
        }
        return CardanoJNAUtil.sign(txnHex, this.privateKey);
    }

    public String sign(String txnHex) throws CborSerializationException {
        if (txnHex == null || txnHex.length() == 0) {
            throw new CborSerializationException("Invalid transaction hash");
        }
        return CardanoJNAUtil.sign(txnHex, this.privateKey);
    }

    public static byte[] toBytes(String address) throws AddressExcepion {
        String hexStr = CardanoJNAUtil.bech32AddressToBytes(address);
        if (hexStr == null || hexStr.length() == 0) {
            throw new AddressExcepion("Address to bytes failed");
        }
        try {
            return HexUtil.decodeHexString(hexStr);
        }
        catch (Exception e) {
            throw new AddressExcepion("Address to bytes failed", e);
        }
    }

    public static String bytesToBech32(byte[] bytes) throws AddressExcepion {
        String bech32Address = CardanoJNAUtil.hexBytesToBech32Address(HexUtil.encodeHexString(bytes));
        if (bech32Address == null || bech32Address.isEmpty()) {
            throw new AddressExcepion("Bytes cannot be converted to bech32 address");
        }
        return bech32Address;
    }

    private void generateNew() {
        String mnemonic;
        this.mnemonic = mnemonic = CardanoJNAUtil.generateMnemonic();
        this.getPrivateKey();
        this.baseAddress();
    }

    private void getPrivateKey() {
        this.privateKey = CardanoJNAUtil.getPrivateKeyFromMnemonic(this.mnemonic, this.index);
        this.privateKeyBytes = CardanoJNAUtil.getPrivateKeyBytesFromMnemonic(this.mnemonic, this.index);
        this.publicKeyBytes = CardanoJNAUtil.getPublicKeyBytesFromMnemonic(this.mnemonic, this.index);
    }

    public String toString() {
        try {
            return this.baseAddress();
        }
        catch (Exception e) {
            return null;
        }
    }
}

