/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api;

import com.bloxbean.cardano.client.backend.api.AddressService;
import com.bloxbean.cardano.client.backend.api.AssetService;
import com.bloxbean.cardano.client.backend.api.BlockService;
import com.bloxbean.cardano.client.backend.api.EpochService;
import com.bloxbean.cardano.client.backend.api.MetadataService;
import com.bloxbean.cardano.client.backend.api.NetworkInfoService;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.api.helper.FeeCalculationService;
import com.bloxbean.cardano.client.backend.api.helper.TransactionHelperService;
import com.bloxbean.cardano.client.backend.api.helper.UtxoTransactionBuilder;
import com.bloxbean.cardano.client.backend.api.helper.impl.FeeCalculationServiceImpl;
import com.bloxbean.cardano.client.backend.api.helper.impl.UtxoTransactionBuilderImpl;

public interface BackendService {
    public AssetService getAssetService();

    public BlockService getBlockService();

    public NetworkInfoService getNetworkInfoService();

    public TransactionService getTransactionService();

    public UtxoService getUtxoService();

    public AddressService getAddressService();

    public EpochService getEpochService();

    public MetadataService getMetadataService();

    default public TransactionHelperService getTransactionHelperService() {
        TransactionHelperService transactionHelperService = new TransactionHelperService(this.getTransactionService(), this.getUtxoService());
        return transactionHelperService;
    }

    default public UtxoTransactionBuilder getUtxoTransactionBuilder() {
        UtxoTransactionBuilderImpl utxoTransactionBuilder = new UtxoTransactionBuilderImpl(this.getUtxoService());
        return utxoTransactionBuilder;
    }

    default public FeeCalculationService getFeeCalculationService() {
        return new FeeCalculationServiceImpl(this.getTransactionHelperService(), this.getEpochService());
    }
}

