/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api.helper;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.backend.api.TransactionService;
import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.api.helper.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.backend.api.helper.UtxoTransactionBuilder;
import com.bloxbean.cardano.client.backend.api.helper.impl.UtxoTransactionBuilderImpl;
import com.bloxbean.cardano.client.backend.api.helper.model.TransactionResult;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.model.Result;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.jna.CardanoJNAUtil;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.transaction.model.MintTransaction;
import com.bloxbean.cardano.client.transaction.model.PaymentTransaction;
import com.bloxbean.cardano.client.transaction.model.TransactionDetailsParams;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHelperService {
    private Logger LOG = LoggerFactory.getLogger(TransactionHelperService.class);
    private TransactionService transactionService;
    private UtxoTransactionBuilder utxoTransactionBuilder;

    public TransactionHelperService(TransactionService transactionService, UtxoService utxoService) {
        this.transactionService = transactionService;
        this.utxoTransactionBuilder = new UtxoTransactionBuilderImpl(utxoService);
    }

    public TransactionHelperService(TransactionService transactionService, UtxoTransactionBuilder utxoTransactionBuilder) {
        this.transactionService = transactionService;
        this.utxoTransactionBuilder = utxoTransactionBuilder;
    }

    public TransactionHelperService(TransactionService transactionService, UtxoSelectionStrategy utxoSelectionStrategy) {
        this.transactionService = transactionService;
        this.utxoTransactionBuilder = new UtxoTransactionBuilderImpl(utxoSelectionStrategy);
    }

    public UtxoTransactionBuilder getUtxoTransactionBuilder() {
        return this.utxoTransactionBuilder;
    }

    public void setUtxoTransactionBuilder(UtxoTransactionBuilder utxoTransactionBuilder) {
        this.utxoTransactionBuilder = utxoTransactionBuilder;
    }

    public Result transfer(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams) throws ApiException, AddressExcepion, CborSerializationException {
        return this.transfer(Arrays.asList(paymentTransaction), detailsParams, null);
    }

    public Result<TransactionResult> transfer(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        return this.transfer(Arrays.asList(paymentTransaction), detailsParams, metadata);
    }

    public Result<TransactionResult> transfer(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams) throws ApiException, AddressExcepion, CborSerializationException {
        return this.transfer(paymentTransactions, detailsParams, null);
    }

    public Result<TransactionResult> transfer(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        String signedTxn = this.createSignedTransaction(paymentTransactions, detailsParams, metadata);
        byte[] signedTxnBytes = HexUtil.decodeHexString(signedTxn);
        Result<String> result = this.transactionService.submitTransaction(signedTxnBytes);
        if (!result.isSuccessful()) {
            this.LOG.error("Trasaction submission failed");
        }
        return this.processTransactionResult(signedTxnBytes, result);
    }

    public String createSignedTransaction(List<PaymentTransaction> paymentTransactions, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        String txnHex;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Requests: \n" + JsonUtil.getPrettyJson(paymentTransactions));
        }
        Transaction transaction = this.utxoTransactionBuilder.buildTransaction(paymentTransactions, detailsParams, metadata);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(JsonUtil.getPrettyJson(transaction));
        }
        String signedTxn = txnHex = transaction.serializeToHex();
        for (PaymentTransaction txn : paymentTransactions) {
            signedTxn = txn.getSender().sign(signedTxn);
            if (txn.getAdditionalWitnessAccounts() == null) continue;
            for (Account additionalWitnessAcc : txn.getAdditionalWitnessAccounts()) {
                signedTxn = additionalWitnessAcc.sign(signedTxn);
            }
        }
        return signedTxn;
    }

    public Result<TransactionResult> mintToken(MintTransaction mintTransaction, TransactionDetailsParams detailsParams) throws AddressExcepion, ApiException, CborSerializationException {
        return this.mintToken(mintTransaction, detailsParams, null);
    }

    public Result<TransactionResult> mintToken(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws AddressExcepion, ApiException, CborSerializationException {
        String signedTxn = this.createSignedMintTransaction(mintTransaction, detailsParams, metadata);
        byte[] signedTxnBytes = HexUtil.decodeHexString(signedTxn);
        Result<String> result = this.transactionService.submitTransaction(signedTxnBytes);
        return this.processTransactionResult(signedTxnBytes, result);
    }

    public String createSignedMintTransaction(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, AddressExcepion, CborSerializationException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Requests: \n" + JsonUtil.getPrettyJson(mintTransaction));
        }
        Transaction transaction = this.utxoTransactionBuilder.buildMintTokenTransaction(mintTransaction, detailsParams, metadata);
        TransactionWitnessSet transactionWitnessSet = new TransactionWitnessSet();
        transactionWitnessSet.getNativeScripts().add(mintTransaction.getPolicyScript());
        transaction.setWitnessSet(transactionWitnessSet);
        transaction.setMetadata(metadata);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(JsonUtil.getPrettyJson(transaction));
        }
        String signedTxn = mintTransaction.getSender().sign(transaction);
        if (mintTransaction.getPolicyKeys() != null) {
            for (SecretKey key : mintTransaction.getPolicyKeys()) {
                signedTxn = CardanoJNAUtil.signWithSecretKey(signedTxn, HexUtil.encodeHexString(key.getBytes()));
            }
        }
        if (mintTransaction.getAdditionalWitnessAccounts() != null) {
            for (Account addWitnessAcc : mintTransaction.getAdditionalWitnessAccounts()) {
                signedTxn = addWitnessAcc.sign(signedTxn);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Signed Txn : " + signedTxn);
        }
        return signedTxn;
    }

    private Result<TransactionResult> processTransactionResult(byte[] signedTxn, Result<String> result) {
        TransactionResult transactionResult = new TransactionResult();
        transactionResult.setSignedTxn(signedTxn);
        if (result.isSuccessful()) {
            transactionResult.setTransactionId(result.getValue());
            return Result.success(result.getResponse()).withValue(transactionResult).code(result.code());
        }
        transactionResult.setTransactionId(null);
        return Result.error(result.getResponse()).withValue(transactionResult).code(result.code());
    }
}

