/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api.helper.impl;

import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.api.helper.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.backend.common.OrderEnum;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.model.Amount;
import com.bloxbean.cardano.client.backend.model.Result;
import com.bloxbean.cardano.client.backend.model.Utxo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DefaultUtxoSelectionStrategyImpl
implements UtxoSelectionStrategy {
    private UtxoService utxoService;

    public DefaultUtxoSelectionStrategyImpl(UtxoService utxoService) {
        this.utxoService = utxoService;
    }

    @Override
    public List<Utxo> selectUtxos(String address, String unit, BigInteger amount, Set<Utxo> excludeUtxos) throws ApiException {
        if (amount == null) {
            amount = BigInteger.ZERO;
        }
        BigInteger totalUtxoAmount = BigInteger.valueOf(0L);
        ArrayList<Utxo> selectedUtxos = new ArrayList<Utxo>();
        boolean canContinue = true;
        int i = 0;
        block0: while (canContinue) {
            Result<List<Utxo>> result = this.utxoService.getUtxos(address, this.getUtxoFetchSize(), i++, this.getUtxoFetchOrder());
            if (result.code() == 200) {
                List<Utxo> fetchData = result.getValue();
                List<Utxo> data = this.filter(fetchData);
                if (data == null || data.isEmpty()) {
                    canContinue = false;
                }
                for (Utxo utxo : data) {
                    if (excludeUtxos.contains(utxo)) continue;
                    List<Amount> utxoAmounts = utxo.getAmount();
                    boolean unitFound = false;
                    for (Amount amt : utxoAmounts) {
                        if (!unit.equals(amt.getUnit())) continue;
                        totalUtxoAmount = totalUtxoAmount.add(amt.getQuantity());
                        unitFound = true;
                    }
                    if (unitFound) {
                        selectedUtxos.add(utxo);
                    }
                    if (totalUtxoAmount.compareTo(amount) != 1) continue;
                    canContinue = false;
                    continue block0;
                }
                continue;
            }
            canContinue = false;
            throw new ApiException(String.format("Unable to get enough Utxos for address : %s, reason: %s", address, result.getResponse()));
        }
        return selectedUtxos;
    }

    protected List<Utxo> filter(List<Utxo> fetchData) {
        return fetchData;
    }

    protected OrderEnum getUtxoFetchOrder() {
        return OrderEnum.asc;
    }

    protected int getUtxoFetchSize() {
        return 40;
    }
}

