/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api.helper.impl;

import com.bloxbean.cardano.client.backend.api.EpochService;
import com.bloxbean.cardano.client.backend.api.helper.FeeCalculationService;
import com.bloxbean.cardano.client.backend.api.helper.TransactionHelperService;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.model.ProtocolParams;
import com.bloxbean.cardano.client.backend.model.Result;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.transaction.model.MintTransaction;
import com.bloxbean.cardano.client.transaction.model.PaymentTransaction;
import com.bloxbean.cardano.client.transaction.model.TransactionDetailsParams;
import com.bloxbean.cardano.client.util.HexUtil;
import java.math.BigInteger;
import java.util.Arrays;

public class FeeCalculationServiceImpl
implements FeeCalculationService {
    private TransactionHelperService transactionHelperService;
    private EpochService epochService;

    public FeeCalculationServiceImpl(TransactionHelperService transactionHelperService, EpochService epochService) {
        this.transactionHelperService = transactionHelperService;
        this.epochService = epochService;
    }

    @Override
    public BigInteger calculateFee(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, CborSerializationException, AddressExcepion {
        Result<ProtocolParams> protocolParamsResult = this.epochService.getProtocolParameters();
        if (!protocolParamsResult.isSuccessful()) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateFee(paymentTransaction, detailsParams, metadata, protocolParamsResult.getValue());
    }

    @Override
    public BigInteger calculateFee(PaymentTransaction paymentTransaction, TransactionDetailsParams detailsParams, Metadata metadata, ProtocolParams protocolParams) throws CborSerializationException, AddressExcepion, ApiException {
        if (paymentTransaction.getFee() == null || paymentTransaction.getFee().compareTo(BigInteger.valueOf(170000L)) == -1) {
            paymentTransaction.setFee(new BigInteger("170000"));
        }
        String txnCBORHash = this.transactionHelperService.createSignedTransaction(Arrays.asList(paymentTransaction), detailsParams, metadata);
        return this.doFeeCalculationFromTxnSize(HexUtil.decodeHexString(txnCBORHash), protocolParams);
    }

    @Override
    public BigInteger calculateFee(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException, CborSerializationException, AddressExcepion {
        Result<ProtocolParams> protocolParamsResult = this.epochService.getProtocolParameters();
        if (!protocolParamsResult.isSuccessful()) {
            throw new ApiException("Unable to fetch protocol parameters to calculate the fee");
        }
        return this.calculateFee(mintTransaction, detailsParams, metadata, protocolParamsResult.getValue());
    }

    @Override
    public BigInteger calculateFee(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata, ProtocolParams protocolParams) throws ApiException, CborSerializationException, AddressExcepion {
        if (mintTransaction.getFee() == null || mintTransaction.getFee().compareTo(BigInteger.valueOf(170000L)) == -1) {
            mintTransaction.setFee(new BigInteger("170000"));
        }
        String txnCBORHash = this.transactionHelperService.createSignedMintTransaction(mintTransaction, detailsParams, metadata);
        return this.doFeeCalculationFromTxnSize(HexUtil.decodeHexString(txnCBORHash), protocolParams);
    }

    private BigInteger doFeeCalculationFromTxnSize(byte[] bytes, ProtocolParams protocolParams) {
        return BigInteger.valueOf(protocolParams.getMinFeeA() * bytes.length + protocolParams.getMinFeeB());
    }
}

