/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.api.helper.impl;

import com.bloxbean.cardano.client.backend.api.UtxoService;
import com.bloxbean.cardano.client.backend.api.helper.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.backend.api.helper.UtxoTransactionBuilder;
import com.bloxbean.cardano.client.backend.api.helper.impl.DefaultUtxoSelectionStrategyImpl;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.backend.exception.InsufficientBalanceException;
import com.bloxbean.cardano.client.backend.model.Amount;
import com.bloxbean.cardano.client.backend.model.Utxo;
import com.bloxbean.cardano.client.common.MinAdaCalculator;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.transaction.model.MintTransaction;
import com.bloxbean.cardano.client.transaction.model.PaymentTransaction;
import com.bloxbean.cardano.client.transaction.model.TransactionDetailsParams;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.AssetUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.bloxbean.cardano.client.util.Tuple;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtxoTransactionBuilderImpl
implements UtxoTransactionBuilder {
    private Logger LOG = LoggerFactory.getLogger(UtxoTransactionBuilderImpl.class);
    private UtxoSelectionStrategy utxoSelectionStrategy;

    public UtxoTransactionBuilderImpl(UtxoService utxoService) {
        this.utxoSelectionStrategy = new DefaultUtxoSelectionStrategyImpl(utxoService);
    }

    public UtxoTransactionBuilderImpl(UtxoSelectionStrategy utxoSelectionStrategy) {
        this.utxoSelectionStrategy = utxoSelectionStrategy;
    }

    @Override
    public void setUtxoSelectionStrategy(UtxoSelectionStrategy utxoSelectionStrategy) {
        this.utxoSelectionStrategy = utxoSelectionStrategy;
    }

    public UtxoSelectionStrategy getUtxoSelectionStrategy() {
        return this.utxoSelectionStrategy;
    }

    @Override
    public Transaction buildTransaction(List<PaymentTransaction> transactions, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException {
        ArrayList<TransactionInput> transactionInputs = new ArrayList<TransactionInput>();
        ArrayList<TransactionOutput> transactionOutputs = new ArrayList<TransactionOutput>();
        Multimap<String, Amount> senderAmountsMap = this.calculateRequiredBalancesForSenders(transactions);
        Map<String, Set<Utxo>> senderToUtxoMap = this.getSenderToUtxosMapFromTransactions(transactions);
        if (senderToUtxoMap == null || senderToUtxoMap.size() == 0) {
            senderToUtxoMap = this.getSenderToUtxosMap(senderAmountsMap);
        }
        BigInteger totalFee = BigInteger.valueOf(0L);
        HashMap<String, BigInteger> senderMiscCostMap = new HashMap<String, BigInteger>();
        for (PaymentTransaction paymentTransaction : transactions) {
            totalFee = this.createReceiverOutputsAndPopulateCost(paymentTransaction, detailsParams, totalFee, transactionOutputs, senderMiscCostMap);
        }
        for (String string : senderMiscCostMap.keySet()) {
            this.checkAndAddAdditionalUtxosIfMinCostIsNotMet(senderToUtxoMap, senderMiscCostMap, string);
        }
        senderToUtxoMap.entrySet().forEach(entry -> {
            String sender = (String)entry.getKey();
            Set utxoSet = (Set)entry.getValue();
            try {
                this.buildOuputsForSenderFromUtxos(sender, utxoSet, transactionInputs, transactionOutputs, senderAmountsMap, senderMiscCostMap, detailsParams);
            }
            catch (ApiException e) {
                this.LOG.error("Error builiding transaction outputs", (Throwable)e);
                throw new ApiRuntimeException("Error building transaction outputs", e);
            }
        });
        TransactionBody transactionBody = TransactionBody.builder().inputs(transactionInputs).outputs(transactionOutputs).fee(totalFee).ttl(detailsParams.getTtl()).validityStartInterval(detailsParams.getValidityStartInterval()).build();
        Transaction transaction = Transaction.builder().body(transactionBody).metadata(metadata).build();
        return transaction;
    }

    @Override
    public List<Utxo> getUtxos(String address, String unit, BigInteger amount) throws ApiException {
        return this.getUtxos(address, unit, amount, Collections.EMPTY_SET);
    }

    @Override
    public Transaction buildMintTokenTransaction(MintTransaction mintTransaction, TransactionDetailsParams detailsParams, Metadata metadata) throws ApiException {
        String sender = mintTransaction.getSender().baseAddress();
        String receiver = mintTransaction.getReceiver();
        if (receiver == null || receiver.isEmpty()) {
            receiver = mintTransaction.getSender().baseAddress();
        }
        BigInteger minAmount = this.createDummyOutputAndCalculateMinAdaForTxnOutput(receiver, mintTransaction.getMintAssets(), detailsParams.getMinUtxoValue());
        BigInteger totalCost = minAmount.add(mintTransaction.getFee());
        List<Utxo> utxos = mintTransaction.getUtxosToInclude();
        if ((utxos == null || utxos.size() == 0) && (utxos = this.getUtxos(sender, "lovelace", totalCost)).size() == 0) {
            throw new InsufficientBalanceException("Not enough utxos found to cover balance : " + totalCost + " lovelace");
        }
        ArrayList<TransactionInput> inputs = new ArrayList<TransactionInput>();
        ArrayList<TransactionOutput> outputs = new ArrayList<TransactionOutput>();
        TransactionOutput transactionOutput = new TransactionOutput();
        transactionOutput.setAddress(sender);
        Value senderValue = Value.builder().coin(BigInteger.ZERO).multiAssets(new ArrayList<MultiAsset>()).build();
        transactionOutput.setValue(senderValue);
        boolean feeDeducted = false;
        for (Utxo utxo : utxos) {
            TransactionInput transactionInput = new TransactionInput(utxo.getTxHash(), utxo.getOutputIndex());
            inputs.add(transactionInput);
            this.copyUtxoValuesToChangeOutput(transactionOutput, utxo);
        }
        BigInteger remainingAmount = transactionOutput.getValue().getCoin().subtract(totalCost);
        transactionOutput.getValue().setCoin(remainingAmount);
        this.verifyMinAdaInOutputAndUpdateIfRequired(inputs, transactionOutput, detailsParams, utxos);
        outputs.add(transactionOutput);
        TransactionOutput mintedTransactionOutput = new TransactionOutput();
        mintedTransactionOutput.setAddress(receiver);
        Value value = Value.builder().coin(minAmount).multiAssets(new ArrayList<MultiAsset>()).build();
        mintedTransactionOutput.setValue(value);
        for (MultiAsset ma : mintTransaction.getMintAssets()) {
            mintedTransactionOutput.getValue().getMultiAssets().add(ma);
        }
        outputs.add(mintedTransactionOutput);
        TransactionBody body = TransactionBody.builder().inputs(inputs).outputs(outputs).fee(mintTransaction.getFee()).ttl(detailsParams.getTtl()).validityStartInterval(detailsParams.getValidityStartInterval()).mint(mintTransaction.getMintAssets()).build();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(JsonUtil.getPrettyJson(body));
        }
        Transaction transaction = Transaction.builder().body(body).metadata(metadata).build();
        return transaction;
    }

    private void verifyMinAdaInOutputAndUpdateIfRequired(List<TransactionInput> inputs, TransactionOutput transactionOutput, TransactionDetailsParams detailsParams, Collection<Utxo> excludeUtxos) throws ApiException {
        BigInteger minRequiredLovelaceInOutput = new MinAdaCalculator(detailsParams.getMinUtxoValue()).calculateMinAda(transactionOutput);
        List ignoreUtxoList = excludeUtxos.stream().map(u -> u).collect(Collectors.toList());
        while (transactionOutput.getValue().getCoin() != null && minRequiredLovelaceInOutput.compareTo(transactionOutput.getValue().getCoin()) == 1) {
            List<Utxo> additionalUtxos = this.getUtxos(transactionOutput.getAddress(), "lovelace", minRequiredLovelaceInOutput, new HashSet<Utxo>(ignoreUtxoList));
            if (additionalUtxos == null || additionalUtxos.size() == 0) {
                throw new InsufficientBalanceException("Not enough utxos found to cover minimum lovelace in an ouput");
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Additional Utoxs found: " + additionalUtxos);
            }
            for (Utxo addUtxo : additionalUtxos) {
                TransactionInput addTxnInput = TransactionInput.builder().transactionId(addUtxo.getTxHash()).index(addUtxo.getOutputIndex()).build();
                inputs.add(addTxnInput);
                this.copyUtxoValuesToChangeOutput(transactionOutput, addUtxo);
            }
            ignoreUtxoList.addAll(additionalUtxos);
            minRequiredLovelaceInOutput = new MinAdaCalculator(detailsParams.getMinUtxoValue()).calculateMinAda(transactionOutput);
        }
    }

    private List<Utxo> getUtxos(String address, String unit, BigInteger amount, Set<Utxo> excludeUtxos) throws ApiException {
        return this.utxoSelectionStrategy.selectUtxos(address, unit, amount, excludeUtxos);
    }

    private void checkAndAddAdditionalUtxosIfMinCostIsNotMet(Map<String, Set<Utxo>> senderToUtxoMap, Map<String, BigInteger> senderMiscCostMap, String sender) throws ApiException {
        BigInteger minCost = senderMiscCostMap.get(sender);
        Set utxos = senderToUtxoMap.getOrDefault(sender, new HashSet());
        BigInteger totalLoveLace = BigInteger.ZERO;
        for (Utxo utxo : utxos) {
            Optional<Amount> optional = utxo.getAmount().stream().filter(amt -> "lovelace".equals(amt.getUnit())).findFirst();
            if (!optional.isPresent()) continue;
            totalLoveLace = totalLoveLace.add(optional.get().getQuantity());
        }
        if (totalLoveLace == null) {
            totalLoveLace = BigInteger.ZERO;
        }
        if (minCost != null && totalLoveLace.compareTo(minCost) != 1) {
            BigInteger additionalAmt = minCost.subtract(totalLoveLace).add(BigInteger.ONE);
            List<Utxo> additionalUtxos = this.getUtxos(sender, "lovelace", additionalAmt);
            if (additionalUtxos == null || additionalUtxos.size() == 0) {
                throw new ApiException(String.format("No utxos found for address for additional amount: %s, unit: %s, amount: %s", sender, "lovelace", additionalAmt));
            }
            utxos.addAll(additionalUtxos);
        }
    }

    private Map<String, Set<Utxo>> getSenderToUtxosMapFromTransactions(List<PaymentTransaction> transactions) {
        HashMap<String, Set<Utxo>> senderToUtxoMap = new HashMap<String, Set<Utxo>>();
        for (PaymentTransaction paymentTransaction : transactions) {
            if (paymentTransaction.getUtxosToInclude() == null || paymentTransaction.getUtxosToInclude().size() <= 0) continue;
            String senderAddress = paymentTransaction.getSender().baseAddress();
            HashSet<Utxo> utxos = (HashSet<Utxo>)senderToUtxoMap.get(senderAddress);
            if (utxos == null) {
                utxos = new HashSet<Utxo>();
                utxos.addAll(paymentTransaction.getUtxosToInclude());
                senderToUtxoMap.put(senderAddress, utxos);
                continue;
            }
            utxos.addAll(paymentTransaction.getUtxosToInclude());
        }
        return senderToUtxoMap;
    }

    private Map<String, Set<Utxo>> getSenderToUtxosMap(Multimap<String, Amount> senderAmountsMap) throws ApiException {
        HashMap<String, Set<Utxo>> senderToUtxoMap = new HashMap<String, Set<Utxo>>();
        for (String sender : senderAmountsMap.keySet()) {
            Collection amts = senderAmountsMap.get((Object)sender);
            if (amts == null || amts.size() == 0) continue;
            HashSet utxoSet = new HashSet();
            for (Amount amt : amts) {
                List<Utxo> utxos = this.getUtxos(sender, amt.getUnit(), amt.getQuantity());
                if (utxos == null || utxos.size() == 0) {
                    throw new ApiException("No utxos found for address : " + sender);
                }
                utxos.forEach(utxo -> utxoSet.add(utxo));
            }
            senderToUtxoMap.put(sender, utxoSet);
        }
        return senderToUtxoMap;
    }

    private BigInteger createReceiverOutputsAndPopulateCost(PaymentTransaction transaction, TransactionDetailsParams detailsParams, BigInteger totalFee, List<TransactionOutput> transactionOutputs, Map<String, BigInteger> senderMiscCostMap) {
        BigInteger existingMiscCost = senderMiscCostMap.getOrDefault(transaction.getSender().baseAddress(), BigInteger.ZERO);
        TransactionOutput.TransactionOutputBuilder outputBuilder = TransactionOutput.builder().address(transaction.getReceiver());
        if ("lovelace".equals(transaction.getUnit())) {
            outputBuilder.value(new Value(transaction.getAmount(), null));
        } else {
            Tuple<String, String> policyIdAssetName = AssetUtil.getPolicyIdAndAssetName(transaction.getUnit());
            Asset asset = new Asset((String)policyIdAssetName._2, transaction.getAmount());
            MultiAsset multiAsset = new MultiAsset((String)policyIdAssetName._1, Arrays.asList(asset));
            outputBuilder.value(new Value(BigInteger.ZERO, Arrays.asList(multiAsset)));
            BigInteger minRequiredAda = new MinAdaCalculator(detailsParams.getMinUtxoValue()).calculateMinAda(outputBuilder.build());
            outputBuilder.value(new Value(minRequiredAda, Arrays.asList(multiAsset)));
            existingMiscCost = existingMiscCost.add(minRequiredAda);
        }
        existingMiscCost = existingMiscCost.add(transaction.getFee());
        senderMiscCostMap.put(transaction.getSender().baseAddress(), existingMiscCost);
        totalFee = totalFee.add(transaction.getFee());
        transactionOutputs.add(outputBuilder.build());
        return totalFee;
    }

    private void buildOuputsForSenderFromUtxos(String sender, Set<Utxo> utxoSet, List<TransactionInput> transactionInputs, List<TransactionOutput> transactionOutputs, Multimap<String, Amount> senderAmountsMap, Map<String, BigInteger> senderMiscCostMap, TransactionDetailsParams detailsParams) throws ApiException {
        TransactionOutput changeOutput = new TransactionOutput(sender, new Value());
        senderAmountsMap.get((Object)sender).stream().forEach(amount -> {
            if ("lovelace".equals(amount.getUnit())) {
                changeOutput.getValue().setCoin(BigInteger.ZERO.subtract(amount.getQuantity()));
            } else {
                Tuple<String, String> policyIdAssetName = AssetUtil.getPolicyIdAndAssetName(amount.getUnit());
                Asset asset = new Asset((String)policyIdAssetName._2, BigInteger.ZERO.subtract(amount.getQuantity()));
                MultiAsset multiAsset = new MultiAsset((String)policyIdAssetName._1, new ArrayList<Asset>(Arrays.asList(asset)));
                changeOutput.getValue().getMultiAssets().add(multiAsset);
            }
        });
        utxoSet.forEach(utxo -> {
            TransactionInput transactionInput = TransactionInput.builder().transactionId(utxo.getTxHash()).index(utxo.getOutputIndex()).build();
            transactionInputs.add(transactionInput);
            this.copyUtxoValuesToChangeOutput(changeOutput, (Utxo)utxo);
        });
        if (changeOutput.getValue().getCoin() != null && changeOutput.getValue().getCoin().compareTo(BigInteger.ZERO) == 1 || changeOutput.getValue().getMultiAssets().size() > 0) {
            BigInteger misCostVal = senderMiscCostMap.get(changeOutput.getAddress());
            BigInteger afterMisCost = changeOutput.getValue().getCoin().subtract(misCostVal);
            changeOutput.getValue().setCoin(afterMisCost);
            this.verifyMinAdaInOutputAndUpdateIfRequired(transactionInputs, changeOutput, detailsParams, utxoSet);
            transactionOutputs.add(changeOutput);
        }
    }

    private void copyUtxoValuesToChangeOutput(TransactionOutput changeOutput, Utxo utxo) {
        utxo.getAmount().forEach(utxoAmt -> {
            String utxoUnit = utxoAmt.getUnit();
            BigInteger utxoQty = utxoAmt.getQuantity();
            if (utxoUnit.equals("lovelace")) {
                BigInteger existingCoin = changeOutput.getValue().getCoin();
                if (existingCoin == null) {
                    existingCoin = BigInteger.ZERO;
                }
                changeOutput.getValue().setCoin(existingCoin.add(utxoQty));
            } else {
                Tuple<String, String> policyIdAssetName = AssetUtil.getPolicyIdAndAssetName(utxoUnit);
                Optional<MultiAsset> multiAssetOptional = changeOutput.getValue().getMultiAssets().stream().filter(ma -> ((String)policyIdAssetName._1).equals(ma.getPolicyId())).findFirst();
                if (multiAssetOptional.isPresent()) {
                    Optional<Asset> assetOptional = multiAssetOptional.get().getAssets().stream().filter(ast -> ((String)policyIdAssetName._2).equals(ast.getName())).findFirst();
                    if (assetOptional.isPresent()) {
                        BigInteger changeVal = assetOptional.get().getValue().add(utxoQty);
                        assetOptional.get().setValue(changeVal);
                    } else {
                        Asset asset = new Asset((String)policyIdAssetName._2, utxoQty);
                        multiAssetOptional.get().getAssets().add(asset);
                    }
                } else {
                    Asset asset = new Asset((String)policyIdAssetName._2, utxoQty);
                    MultiAsset multiAsset = new MultiAsset((String)policyIdAssetName._1, new ArrayList<Asset>(Arrays.asList(asset)));
                    changeOutput.getValue().getMultiAssets().add(multiAsset);
                }
            }
        });
        List<MultiAsset> multiAssets = changeOutput.getValue().getMultiAssets();
        ArrayList markedForRemoval = new ArrayList();
        if (multiAssets != null && multiAssets.size() > 0) {
            multiAssets.forEach(ma -> {
                if (ma.getAssets() == null || ma.getAssets().size() == 0) {
                    markedForRemoval.add(ma);
                }
            });
            multiAssets.removeAll(markedForRemoval);
        }
    }

    private Multimap<String, Amount> calculateRequiredBalancesForSenders(List<PaymentTransaction> transactions) {
        ArrayListMultimap senderAmountMap = ArrayListMultimap.create();
        for (PaymentTransaction transaction : transactions) {
            String sender = transaction.getSender().baseAddress();
            String unit = transaction.getUnit();
            BigInteger amount = transaction.getAmount();
            this.addAmountToSenderAmountMap((Multimap<String, Amount>)senderAmountMap, sender, unit, amount);
        }
        return senderAmountMap;
    }

    private void addAmountToSenderAmountMap(Multimap<String, Amount> senderAmountMap, String sender, String unit, BigInteger amount) {
        Collection amounts = senderAmountMap.get((Object)sender);
        if (amounts != null && amounts.size() > 0) {
            Optional<Amount> existingAmtOptional = amounts.stream().filter(amt -> unit.equals(amt.getUnit())).findFirst();
            if (existingAmtOptional.isPresent()) {
                Amount existingAmt = existingAmtOptional.get();
                existingAmt.setQuantity(existingAmt.getQuantity().add(amount));
            } else {
                senderAmountMap.put((Object)sender, (Object)new Amount(unit, amount));
            }
        } else {
            senderAmountMap.put((Object)sender, (Object)new Amount(unit, amount));
        }
    }

    private BigInteger createDummyOutputAndCalculateMinAdaForTxnOutput(String address, List<MultiAsset> multiAssets, BigInteger minUtxoValue) {
        TransactionOutput txnOutput = new TransactionOutput();
        txnOutput.setAddress(address);
        txnOutput.setValue(new Value(BigInteger.ZERO, multiAssets));
        return new MinAdaCalculator(minUtxoValue).calculateMinAda(txnOutput);
    }
}

