/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.api.AddressService;
import com.bloxbean.cardano.client.backend.common.OrderEnum;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.http.AddressesApi;
import com.bloxbean.cardano.client.backend.model.AddressContent;
import com.bloxbean.cardano.client.backend.model.Result;
import java.io.IOException;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFAddressService
extends BFBaseService
implements AddressService {
    private AddressesApi addressApi = (AddressesApi)this.getRetrofit().create(AddressesApi.class);

    public BFAddressService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    @Override
    public Result<AddressContent> getAddressInfo(String address) throws ApiException {
        Call<AddressContent> call = this.addressApi.getAddressInfo(this.getProjectId(), address);
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting addressInfo", e);
        }
    }

    @Override
    public Result<List<String>> getTransactions(String address, int count, int page) throws ApiException {
        return this.getTransactions(address, count, page, OrderEnum.asc);
    }

    @Override
    public Result<List<String>> getTransactions(String address, int count, int page, OrderEnum order) throws ApiException {
        Call<List<String>> call = this.addressApi.getTransactions(this.getProjectId(), address, count, page, order.toString());
        try {
            Response response = call.execute();
            return this.processResponse(response);
        }
        catch (IOException e) {
            throw new ApiException("Error getting transactions for the address", e);
        }
    }
}

