/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.api.AssetService;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.http.AssetsApi;
import com.bloxbean.cardano.client.backend.model.Asset;
import com.bloxbean.cardano.client.backend.model.Result;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public class BFAssetService
extends BFBaseService
implements AssetService {
    private final AssetsApi assetsApi = (AssetsApi)this.getRetrofit().create(AssetsApi.class);

    public BFAssetService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    @Override
    public Result<Asset> getAsset(String assetId) throws ApiException {
        Call<Asset> assetReponse = this.assetsApi.getAsset(this.getProjectId(), assetId);
        try {
            Response response = assetReponse.execute();
            if (response.isSuccessful()) {
                return Result.success(response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting asset info", e);
        }
    }
}

