/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.model.Result;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class BFBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(BFBaseService.class);
    private String baseUrl;
    private String projectId;

    public BFBaseService(String baseUrl, String projectId) {
        this.baseUrl = baseUrl;
        this.projectId = projectId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Blockfrost URL : " + baseUrl);
        }
    }

    protected Retrofit getRetrofit() {
        return new Retrofit.Builder().baseUrl(this.getBaseUrl()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getProjectId() {
        return this.projectId;
    }

    protected <T> Result<T> processResponse(Response<T> response) throws IOException {
        if (response.isSuccessful()) {
            return Result.success(response.toString()).withValue(response.body()).code(response.code());
        }
        return Result.error(response.errorBody().string()).code(response.code());
    }
}

