/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.api.EpochService;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.http.EpochApi;
import com.bloxbean.cardano.client.backend.model.EpochContent;
import com.bloxbean.cardano.client.backend.model.ProtocolParams;
import com.bloxbean.cardano.client.backend.model.Result;
import java.io.IOException;
import retrofit2.Call;
import retrofit2.Response;

public class BFEpochService
extends BFBaseService
implements EpochService {
    private EpochApi epochApi = (EpochApi)this.getRetrofit().create(EpochApi.class);

    public BFEpochService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    @Override
    public Result<EpochContent> getLatestEpoch() throws ApiException {
        Call<EpochContent> call = this.epochApi.getLatestEpoch(this.getProjectId());
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Result.success(response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting latest epoch", e);
        }
    }

    @Override
    public Result<EpochContent> getEpoch(Integer epoch) throws ApiException {
        Call<EpochContent> call = this.epochApi.getEpochByNumber(this.getProjectId(), epoch);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Result.success(response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting epoch by number : " + epoch, e);
        }
    }

    @Override
    public Result<ProtocolParams> getProtocolParameters(Integer epoch) throws ApiException {
        Call<ProtocolParams> call = this.epochApi.getProtocolParameters(this.getProjectId(), epoch);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Result.success(response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting protocol paramters by number : " + epoch, e);
        }
    }

    @Override
    public Result<ProtocolParams> getProtocolParameters() throws ApiException {
        Result<EpochContent> epochContentResult = this.getLatestEpoch();
        if (!epochContentResult.isSuccessful()) {
            throw new ApiException("Unable to get latest epoch info to get protocol paramters");
        }
        EpochContent epochContent = epochContentResult.getValue();
        if (epochContent == null) {
            throw new ApiException("Unable to get latest epoch info to get protocol paramters");
        }
        return this.getProtocolParameters(epochContent.getEpoch());
    }
}

