/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.api.MetadataService;
import com.bloxbean.cardano.client.backend.common.OrderEnum;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.http.MetadataApi;
import com.bloxbean.cardano.client.backend.model.Result;
import com.bloxbean.cardano.client.backend.model.metadata.MetadataCBORContent;
import com.bloxbean.cardano.client.backend.model.metadata.MetadataJSONContent;
import com.bloxbean.cardano.client.backend.model.metadata.MetadataLabel;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import retrofit2.Call;
import retrofit2.Response;

public class BFMetadataService
extends BFBaseService
implements MetadataService {
    private MetadataApi metadataApi = (MetadataApi)this.getRetrofit().create(MetadataApi.class);

    public BFMetadataService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    @Override
    public Result<List<MetadataJSONContent>> getJSONMetadataByTxnHash(String txnHash) throws ApiException {
        Call<List<MetadataJSONContent>> call = this.metadataApi.getJSONMetadataByTxnHash(this.getProjectId(), txnHash);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                List value = (List)response.body();
                if (value != null) {
                    value.stream().forEach(v -> v.setTxHash(txnHash));
                }
                return Result.success(response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting metadata for the transaction", e);
        }
    }

    @Override
    public Result<List<MetadataCBORContent>> getCBORMetadataByTxnHash(String txnHash) throws ApiException {
        Call<List<MetadataCBORContent>> call = this.metadataApi.getCBORMetadataByTxnHash(this.getProjectId(), txnHash);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                List value = (List)response.body();
                if (value != null) {
                    value.stream().forEach(v -> v.setTxHash(txnHash));
                }
                return Result.success(response.toString()).withValue(value).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting cbor metadata for the transaction", e);
        }
    }

    @Override
    public Result<List<MetadataLabel>> getMetadataLabels(int count, int page, OrderEnum order) throws ApiException {
        if (order == null) {
            order = OrderEnum.asc;
        }
        Call<List<MetadataLabel>> call = this.metadataApi.getMetadataLabels(this.getProjectId(), count, page, order.toString());
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return Result.success(response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting metadata labels", e);
        }
    }

    @Override
    public Result<List<MetadataJSONContent>> getJSONMetadataByLabel(BigInteger label, int count, int page, OrderEnum order) throws ApiException {
        if (order == null) {
            order = OrderEnum.asc;
        }
        Call<List<MetadataJSONContent>> call = this.metadataApi.getJSONMetadataByLabel(this.getProjectId(), label, count, page, order.toString());
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                List values = (List)response.body();
                if (values != null) {
                    values.forEach(v -> v.setLabel(String.valueOf(label)));
                }
                return Result.success(response.toString()).withValue(values).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting metadata by label", e);
        }
    }

    @Override
    public Result<List<MetadataCBORContent>> getCBORMetadataByLabel(BigInteger label, int count, int page, OrderEnum order) throws ApiException {
        if (order == null) {
            order = OrderEnum.asc;
        }
        Call<List<MetadataCBORContent>> call = this.metadataApi.getCBORMetadatabyLabel(this.getProjectId(), label, count, page, order.toString());
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                List values = (List)response.body();
                if (values != null) {
                    values.forEach(v -> v.setLabel(label.toString()));
                }
                return Result.success(response.toString()).withValue(values).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting cbor metadata by label", e);
        }
    }
}

