/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.backend.impl.blockfrost.service;

import com.bloxbean.cardano.client.backend.api.NetworkInfoService;
import com.bloxbean.cardano.client.backend.exception.ApiException;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.BFBaseService;
import com.bloxbean.cardano.client.backend.impl.blockfrost.service.http.CardanoLedgerApi;
import com.bloxbean.cardano.client.backend.model.Genesis;
import com.bloxbean.cardano.client.backend.model.Result;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class BFNetworkService
extends BFBaseService
implements NetworkInfoService {
    private static final Logger LOG = LoggerFactory.getLogger(BFNetworkService.class);
    private CardanoLedgerApi ledgerApi = (CardanoLedgerApi)this.getRetrofit().create(CardanoLedgerApi.class);

    public BFNetworkService(String baseUrl, String projectId) {
        super(baseUrl, projectId);
    }

    @Override
    public Result<Genesis> getNetworkInfo() throws ApiException {
        Call<Genesis> genesisCall = this.ledgerApi.genesis(this.getProjectId());
        try {
            Response response = genesisCall.execute();
            if (response.isSuccessful()) {
                return Result.success(response.toString()).withValue(response.body()).code(response.code());
            }
            return Result.error(response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting genesis info", e);
        }
    }
}

